/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators.xml2xsd;

import java.io.IOException;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.xml2xsd.XMLSchemaGeneratorSettings;
import org.junit.jupiter.api.Test;

public class XML2XMLSchemaGeneratorTest
extends AbstractCacheBasedTest {
    @Test
    public void schema() throws IOException {
        String xml = "<note>\r\n\t<to>Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"to\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"from\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"heading\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"body\" type=\"xs:string\" />" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void schemaWithNS() throws IOException {
        String xml = "<note xmlns=\"https://www.w3schools.com\">\r\n\t<to>Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"https://www.w3schools.com\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"to\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"from\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"heading\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"body\" type=\"xs:string\" />" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void schemaWithDecimalAttr() throws IOException {
        String xml = "<note version=\"1.2\" />";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:attribute name=\"version\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void schemaWithDecimalAttrAndContent() throws IOException {
        String xml = "<note version=\"1.2\" >ABCD</note>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:simpleContent>" + System.lineSeparator() + "        <xs:extension base=\"xs:string\">" + System.lineSeparator() + "          <xs:attribute name=\"version\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "        </xs:extension>" + System.lineSeparator() + "      </xs:simpleContent>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void schemaWithDecimalAttrAndMixedContent() throws IOException {
        String xml = "<note version=\"1.2\" >AB<C/>D</note>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType mixed=\"true\">" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"C\" />" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "      <xs:attribute name=\"version\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void schemaWithAttrs() throws IOException {
        String xml = "<note version=\"1.2\" >\r\n\t<to attr1=\"abcd\" attr2=\"efgh\">Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"note\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"to\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:simpleContent>" + System.lineSeparator() + "              <xs:extension base=\"xs:string\">" + System.lineSeparator() + "                <xs:attribute name=\"attr1\" use=\"required\" />" + System.lineSeparator() + "                <xs:attribute name=\"attr2\" use=\"required\" />" + System.lineSeparator() + "              </xs:extension>" + System.lineSeparator() + "            </xs:simpleContent>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "        <xs:element name=\"from\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"heading\" type=\"xs:string\" />" + System.lineSeparator() + "        <xs:element name=\"body\" type=\"xs:string\" />" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "      <xs:attribute name=\"version\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void mixedContent() {
        String xml = "<a><b/>text</a>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"a\">" + System.lineSeparator() + "    <xs:complexType mixed=\"true\">" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"b\" />" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void threeLevel() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c/>\r\n\t</b>\r\n</a>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"a\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"b\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:sequence>" + System.lineSeparator() + "              <xs:element name=\"c\" />" + System.lineSeparator() + "            </xs:sequence>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void threeLevelAndText() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c />\r\n\t\t<d>X</d>\r\n\t</b>\r\n</a>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"a\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"b\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:sequence>" + System.lineSeparator() + "              <xs:element name=\"c\" />" + System.lineSeparator() + "              <xs:element name=\"d\" type=\"xs:string\" />" + System.lineSeparator() + "            </xs:sequence>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void occurrences() {
        String xml = "<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"grocery-invoice.xsd\">\r\n  <item name=\"Rice\" price=\"4.99\" />\r\n  <item name=\"Baked Beans\" price=\"1.99\" />\r\n  <item name=\"Salad\" price=\"5.99\" />\r\n</invoice>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"invoice\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"name\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"price\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void oneZeroOccurrences() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"a\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:sequence minOccurs=\"0\">" + System.lineSeparator() + "              <xs:element name=\"b\" minOccurs=\"0\" />" + System.lineSeparator() + "            </xs:sequence>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void oneZeroOccurrences2() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a>\r\n        <c />\r\n    </a>\r\n    <a>\r\n        <b />\r\n        <c />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"a\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:sequence minOccurs=\"0\">" + System.lineSeparator() + "              <xs:element name=\"b\" minOccurs=\"0\" />" + System.lineSeparator() + "              <xs:element name=\"c\" minOccurs=\"0\" />" + System.lineSeparator() + "            </xs:sequence>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void choice() {
        String xml = "<root>\r\n\t<a>\r\n\t\t<c />\r\n\t\t<b />\r\n\t</a>\r\n\t<a>\r\n\t\t<b />\r\n\t\t<c />\r\n\t</a>\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"a\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:sequence>" + System.lineSeparator() + "              <xs:choice>" + System.lineSeparator() + "                <xs:element name=\"c\" />" + System.lineSeparator() + "                <xs:element name=\"b\" />" + System.lineSeparator() + "                <xs:choice>" + System.lineSeparator() + "            </xs:sequence>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void optionalAttribute() {
        String xml = "<root>\r\n\t<item attr1=\"\" attr2=\"\"/>\r\n\t<item attr1=\"\" />\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"attr1\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"attr2\" />" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void attrIDsAndFixed() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"A\" />\r\n\t<item attr1=\"id7\" attr2=\"A\" />\r\n\t<item attr1=\"id8\" attr2=\"A\" />\r\n\t<item attr1=\"id9\" attr2=\"A\" />\r\n\t<item attr1=\"id10\" attr2=\"A\" />\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"attr1\" type=\"xs:ID\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"attr2\" use=\"required\" fixed=\"A\" />" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void attrIDsAndEnums() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"B\" />\r\n\t<item attr1=\"id7\" attr2=\"B\" />\r\n\t<item attr1=\"id8\" attr2=\"B\" />\r\n\t<item attr1=\"id9\" attr2=\"B\" />\r\n\t<item attr1=\"id10\" attr2=\"B\" />\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"attr1\" type=\"xs:ID\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"attr2\" use=\"required\">" + System.lineSeparator() + "              <xs:simpleType>" + System.lineSeparator() + "                <xs:restriction base=\"xs:string\">" + System.lineSeparator() + "                  <xs:enumeration value=\"A\" />" + System.lineSeparator() + "                  <xs:enumeration value=\"B\" />" + System.lineSeparator() + "                </xs:restriction>" + System.lineSeparator() + "              </xs:simpleType>" + System.lineSeparator() + "            </xs:attribute>" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void attrTypes() {
        String xml = "<root>\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"1.2\"  />\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"dateTime\" type=\"xs:dateTime\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"date\" type=\"xs:date\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"boolean\" type=\"xs:boolean\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"integer\" type=\"xs:integer\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"decimal\" type=\"xs:decimal\" use=\"required\" />" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }

    @Test
    public void attrTypesWith2Occurs() {
        String xml = "<root>\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"1.2\"  />\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"XXXXXXXXXXXXXXXXXXXXXX\"  />\r\n</root>";
        String xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\">" + System.lineSeparator() + "    <xs:complexType>" + System.lineSeparator() + "      <xs:sequence>" + System.lineSeparator() + "        <xs:element name=\"item\" maxOccurs=\"unbounded\">" + System.lineSeparator() + "          <xs:complexType>" + System.lineSeparator() + "            <xs:attribute name=\"dateTime\" type=\"xs:dateTime\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"date\" type=\"xs:date\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"boolean\" type=\"xs:boolean\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"integer\" type=\"xs:integer\" use=\"required\" />" + System.lineSeparator() + "            <xs:attribute name=\"decimal\" use=\"required\" />" + System.lineSeparator() + "          </xs:complexType>" + System.lineSeparator() + "        </xs:element>" + System.lineSeparator() + "      </xs:sequence>" + System.lineSeparator() + "    </xs:complexType>" + System.lineSeparator() + "  </xs:element>" + System.lineSeparator() + "</xs:schema>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new XMLSchemaGeneratorSettings(), xsd);
    }
}

