/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.DocumentLink;
import org.junit.jupiter.api.Test;

public class XMLSchemaDocumentLinkTest
extends AbstractCacheBasedTest {
    @Test
    public void noNamespaceSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/Format.xsd\">\r\n  <ViewDefinitions>\r\n    <View>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/Format.xml", XMLAssert.dl(XMLAssert.r(1, 100, 1, 114), "src/test/resources/xsd/Format.xsd"));
    }

    @Test
    public void singleSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://example.org/schema/format xsd/Format.xsd\">\r\n  <ViewDefinitions>\r\n    <View>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/Format.xml", XMLAssert.dl(XMLAssert.r(1, 122, 1, 136), "src/test/resources/xsd/Format.xsd"));
    }

    @Test
    public void manySchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"http://www.example.org/schema/beans xsd/spring-beans.xsd http://www.example.org/schema/spring xsd/camel-spring.xsd http://www.example.org/schema/salad xsd/salad.xsd\">\r\n";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/beans-and-salad.xml", XMLAssert.dl(XMLAssert.r(5, 63, 5, 83), "src/test/resources/xsd/spring-beans.xsd"), XMLAssert.dl(XMLAssert.r(5, 178, 5, 191), "src/test/resources/xsd/salad.xsd"), XMLAssert.dl(XMLAssert.r(5, 121, 5, 141), "src/test/resources/xsd/camel-spring.xsd"));
    }

    @Test
    public void lineBreakManySchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.example.org/schema/beans xsd/spring-beans.xsd\r\n         http://www.example.org/schema/spring xsd/camel-spring.xsd\r\n         http://www.example.org/schema/salad xsd/salad.xsd\">\r\n";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/beans-and-salad.xml", XMLAssert.dl(XMLAssert.r(6, 45, 6, 65), "src/test/resources/xsd/spring-beans.xsd"), XMLAssert.dl(XMLAssert.r(8, 45, 8, 58), "src/test/resources/xsd/salad.xsd"), XMLAssert.dl(XMLAssert.r(7, 46, 7, 66), "src/test/resources/xsd/camel-spring.xsd"));
    }

    @Test
    public void blankSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\" />";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xsd/bean.xml", new DocumentLink[0]);
    }

    @Test
    public void incompleteSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://example.org/schema/format\">\r\n  <ViewDefinitions>\r\n    <View>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/Format.xml", new DocumentLink[0]);
    }

    @Test
    public void secondTokenIsIncompleteSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.example.org/schema/beans xsd/spring-beans.xsd\r\n         http://www.example.org/schema/spring\" />\r\n";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/beans-and-salad.xml", XMLAssert.dl(XMLAssert.r(6, 45, 6, 65), "src/test/resources/xsd/spring-beans.xsd"));
    }
}

