/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterForDTDTest {
    @Disabled
    @Test
    public void testDoctypeNoInternalSubset() throws BadLocationException {
        String content = "<!DOCTYPE    note\r\n\r\n>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n  <from>Jani</from>\r\n\r\n  <heading>Reminder</heading>\r\n  \r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        String expected = "<!DOCTYPE note>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n  <from>Jani</from>\r\n\r\n  <heading>Reminder</heading>\r\n\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testDoctypeNoInternalSubsetNoNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreservedNewlines(0);
        String content = "<!DOCTYPE    note\r\n\r\n>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n  <from>Jani</from>\r\n\r\n  <heading>Reminder</heading>\r\n  \r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        String expected = "<!DOCTYPE note>\r\n<note>\r\n  <to>Fred</to>\r\n  <from>Jani</from>\r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, XMLAssert.te(0, 9, 0, 13, " "), XMLAssert.te(0, 17, 2, 0, ""), XMLAssert.te(4, 15, 6, 2, "\r\n  "), XMLAssert.te(6, 19, 8, 2, "\r\n  "), XMLAssert.te(8, 29, 10, 2, "\r\n  "));
        XMLFormatterForDTDTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeInternalSubset() throws BadLocationException {
        String content = "<!DOCTYPE note\r\n\r\n\r\n[        <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)><!ELEMENT from (#PCDATA)>\r\n  \r\n  \r\n  <!ELEMENT heading (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n\r\n  <from>Jani</from>\r\n  \r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)>\r\n  <!ELEMENT from (#PCDATA)>\r\n  <!ELEMENT heading (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n\r\n  <from>Jani</from>\r\n\r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeInternalSubsetNoNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreservedNewlines(0);
        String content = "<!DOCTYPE note\r\n\r\n\r\n[        <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)><!ELEMENT from (#PCDATA)>\r\n  \r\n  \r\n  <!ELEMENT heading (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n\r\n\r\n  <from>Jani</from>\r\n  \r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)>\r\n  <!ELEMENT from (#PCDATA)>\r\n  <!ELEMENT heading (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n  <from>Jani</from>\r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDoctypeInternalDeclSpacesBetweenParameters() throws BadLocationException {
        String content = "<!DOCTYPE note [\r\n  <!ELEMENT    note (to,from,heading,body)>\r\n  <!ELEMENT   to     (#PCDATA)>\r\n  <!ELEMENT from (#PCDATA)>\r\n  <!ELEMENT heading   (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n  <from>Jani</from>\r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)>\r\n  <!ELEMENT from (#PCDATA)>\r\n  <!ELEMENT heading (#PCDATA)>\r\n  <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n  <to>Fred</to>\r\n  <from>Jani</from>\r\n  <heading>Reminder</heading>\r\n  <body>Don't forget me this weekend</body>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, XMLAssert.te(1, 11, 1, 15, " "), XMLAssert.te(2, 11, 2, 14, " "), XMLAssert.te(2, 16, 2, 21, " "), XMLAssert.te(4, 19, 4, 22, " "));
        XMLFormatterForDTDTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeInternalWithAttlist() throws BadLocationException {
        String content = "<!DOCTYPE note \r\n[\r\n  <!ELEMENT note (to,from,heading,body)>\r\n\r\n  <!ELEMENT to (#PCDATA)>\r\n\r\n  <!ATTLIST payment type CDATA \"check\">\r\n\r\n]>\r\n\r\n<note>\r\n  \r\n  <to>Fred</to>\r\n</note>";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ELEMENT to (#PCDATA)>\r\n  <!ATTLIST payment type CDATA \"check\">\r\n]>\r\n\r\n<note>\r\n\r\n  <to>Fred</to>\r\n</note>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testDoctypeInternalAllDecls() throws BadLocationException {
        String content = "<!DOCTYPE note\r\n[\r\n\r\n  <!ELEMENT note (to,from,heading,body)>\r\n\r\n  <!ATTLIST payment type CDATA \"check\">\r\n\r\n  <!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n\r\n  <!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">\r\n]>\r\n";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ATTLIST payment type CDATA \"check\">\r\n  <!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n  <!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">\r\n]>";
        XMLFormatterForDTDTest.assertFormat(content, expected, XMLAssert.te(0, 14, 1, 0, " "), XMLAssert.te(1, 1, 3, 2, "\r\n  "), XMLAssert.te(3, 40, 5, 2, "\r\n  "), XMLAssert.te(5, 39, 7, 2, "\r\n  "), XMLAssert.te(7, 69, 9, 2, "\r\n  "), XMLAssert.te(10, 2, 11, 0, ""));
        XMLFormatterForDTDTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeInternalWithComments() throws BadLocationException {
        String content = "<!DOCTYPE note\r\n[ \r\n  <!-- comment -->\r\n\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  \r\n  \r\n  <!ATTLIST payment type CDATA \"check\">\r\n  \r\n  <!-- comment -->\r\n  \r\n  <!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n  <!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">\r\n]>\r\n";
        String expected = "<!DOCTYPE note [\r\n  <!-- comment -->\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  <!ATTLIST payment type CDATA \"check\">\r\n  <!-- comment -->\r\n  <!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n  <!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">\r\n]>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeInternalWithText() throws BadLocationException {
        String content = "<!DOCTYPE note\r\n[\r\n  <!ELEMENT note (to,from,heading,body)>\r\n\r\n\r\n  garbageazg df\r\n                gdf\r\ngarbageazgdfg\r\n  df\r\n  gd\r\n\r\n\r\n  \r\n  <!ELEMENT note (to,from,heading,body)>\r\n  \r\n]>";
        String expected = "<!DOCTYPE note [\r\n  <!ELEMENT note (to,from,heading,body)>\r\n  garbageazg df\r\n                gdf\r\ngarbageazgdfg\r\n  df\r\n  gd\r\n  <!ELEMENT note (to,from,heading,body)>\r\n]>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testDTDMultiParameterAttlist() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "\r\n<!ATTLIST array name CDATA #IMPLIED description CDATA #IMPLIED disabled CDATA #IMPLIED>";
        String expected = "<!ATTLIST array\r\n  name CDATA #IMPLIED\r\n  description CDATA #IMPLIED\r\n  disabled CDATA #IMPLIED>";
        XMLFormatterForDTDTest.assertDTDFormat(content, expected, settings, XMLAssert.te(0, 0, 1, 0, ""), XMLAssert.te(1, 15, 1, 16, "\r\n  "), XMLAssert.te(1, 35, 1, 36, "\r\n  "), XMLAssert.te(1, 62, 1, 63, "\r\n  "));
        XMLFormatterForDTDTest.assertDTDFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDTDIndentation() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "  <!ELEMENT note (to,from,heading,body)>\r\n\t\t\t\r\n\t\t\t<!ATTLIST payment type CDATA \"check\">\r\n\t\t\t\r\n\t\t\t\t  <!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n\t\t\t\t\r\n\t\t\t\t  <!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">";
        String expected = "<!ELEMENT note (to,from,heading,body)>\r\n<!ATTLIST payment type CDATA \"check\">\r\n<!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDTDNotEndBrackets() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<!ELEMENT note (to,from,heading,body)\r\n\r\n<!ATTLIST payment type CDATA \"check\"\r\n\r\n<!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\"\r\n<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\"";
        String expected = "<!ELEMENT note (to,from,heading,body)\r\n<!ATTLIST payment type CDATA \"check\"\r\n<!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\"\r\n<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\"";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDTDUnknownDeclNameAndText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<!ELEMENT note (to,from,heading,body)>\r\n\r\n\r\n  <!hellament afsfas >\r\n\r\n  asdasd\r\n  asd\r\n\r\n<!ATTLIST payment type CDATA \"check\">\r\n<!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">";
        String expected = "<!ELEMENT note (to,from,heading,body)>\r\n<!hellament afsfas >\r\nasdasd\r\n  asd\r\n<!ATTLIST payment type CDATA \"check\">\r\n<!ENTITY copyright SYSTEM \"https://www.w3schools.com/entities.dtd\">\r\n<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\">";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testAllDoctypeParameters() throws BadLocationException {
        String content = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\" [\r\n        <!ELEMENT h1 %horiz.model;>\r\n  <!ATTLIST h1 %all;>\r\n  <!ELEMENT h2 %horiz.model;>\r\n\r\n\r\n          <!ATTLIST h2 %all;>\r\n  <!ELEMENT h3 %horiz.model;>\r\n  <!ATTLIST h3 %all;>\r\n]\r\n\r\n\r\n>\r\n<web-app>\r\n  <display-name>sdsd</display-name>\r\n\r\n  <servlet>\r\n    \r\n    <servlet-name>er</servlet-name>\r\n    <servlet-class>dd</servlet-class>\r\n  </servlet>\r\n</web-app>";
        String expected = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\" [\r\n  <!ELEMENT h1 %horiz.model;>\r\n  <!ATTLIST h1 %all;>\r\n  <!ELEMENT h2 %horiz.model;>\r\n  <!ATTLIST h2 %all;>\r\n  <!ELEMENT h3 %horiz.model;>\r\n  <!ATTLIST h3 %all;>\r\n]>\r\n<web-app>\r\n  <display-name>sdsd</display-name>\r\n\r\n  <servlet>\r\n\r\n    <servlet-name>er</servlet-name>\r\n    <servlet-class>dd</servlet-class>\r\n  </servlet>\r\n</web-app>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDTDElementContentWithAsterisk() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<!ELEMENT data    (#PCDATA | data | d0)*   >";
        String expected = "<!ELEMENT data (#PCDATA | data | d0)*>";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDoctypeSingleLineFormat() throws BadLocationException {
        String content = "<!DOCTYPE name [<!-- MY COMMENT --><!NOTATION postscript SYSTEM \"ghostview\">]>\r\n";
        String expected = "<!DOCTYPE name [\r\n  <!-- MY COMMENT -->\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testDoctypeInvalidParameter() throws BadLocationException {
        String content = "<!DOCTYPE name \"url\" [\r\n  <!-- MY COMMENT -->\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>";
        String expected = "<!DOCTYPE name \"url\" [\r\n  <!-- MY COMMENT -->\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testDoctypeInvalidParameterUnclosed() throws BadLocationException {
        String content = "<!DOCTYPE name \"url\"[ <!-- MY COMMENT -->\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]\r\n\r\n\r\n<a></a>";
        String expected = "<!DOCTYPE name \"url\"[ <!-- MY COMMENT -->\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]\r\n<a></a>";
        XMLFormatterForDTDTest.assertFormat(content, expected, XMLAssert.te(2, 1, 5, 0, "\r\n"));
        XMLFormatterForDTDTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUnclosedSystemId() throws BadLocationException {
        String content = "<!DOCTYPE name PUBLIC \"lass\" \"bass [ <!-- MY COMMENT -->\r\n\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>\r\n\r\n<a></a>";
        String expected = "<!DOCTYPE name PUBLIC \"lass\" \"bass [ <!-- MY COMMENT -->\r\n\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>\r\n\r\n<a></a>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUnclosedPublicId() throws BadLocationException {
        String content = "<!DOCTYPE name PUBLIC \"lass  [ <!-- MY COMMENT -->\r\n\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>\r\n\r\n<a></a>";
        String expected = "<!DOCTYPE name PUBLIC \"lass  [ <!-- MY COMMENT -->\r\n\r\n  <!NOTATION postscript SYSTEM \"ghostview\">\r\n]>\r\n\r\n<a></a>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentAfterMissingClosingBracket() throws BadLocationException {
        String content = "<!DOCTYPE name [\r\n  <!ENTITY % astroTerms SYSTEM \"http://xml.gsfc.nasa.gov/DTD/entities/astroTerms.ent\"\r\n\r\n  <!-- MY COMMENT -->\r\n]>\r\n\r\n<a></a>";
        String expected = "<!DOCTYPE name [\r\n  <!ENTITY % astroTerms SYSTEM \"http://xml.gsfc.nasa.gov/DTD/entities/astroTerms.ent\"\r\n  <!-- MY COMMENT -->\r\n]>\r\n\r\n<a></a>";
        XMLFormatterForDTDTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testHTMLDTD() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<!--\r\n  Further information about HTML 4.01 is available at:\r\n-->\r\n<!ENTITY % HTML.Version \"-//W3C//DTD HTML 4.01 Frameset//EN\"\r\n  -- Typical usage:\r\n\r\n    <!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\r\n            \"http://www.w3.org/TR/html4/frameset.dtd\">\r\n    <html>\r\n    <head>\r\n    ...\r\n    </head>\r\n    <frameset>\r\n    ...\r\n    </frameset>\r\n    </html>\r\n-->\r\n\r\n<!ENTITY % HTML.Frameset \"INCLUDE\">\r\n<!ENTITY % HTML4.dtd PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n%HTML4.dtd;";
        String expected = "<!--\r\n  Further information about HTML 4.01 is available at:\r\n-->\r\n<!ENTITY % HTML.Version \"-//W3C//DTD HTML 4.01 Frameset//EN\" -- Typical usage:\r\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\r\n            \"http://www.w3.org/TR/html4/frameset.dtd\">\r\n<html>\r\n<head>\r\n...\r\n</head>\r\n<frameset>\r\n...\r\n</frameset>\r\n</html>\r\n-->\r\n<!ENTITY % HTML.Frameset \"INCLUDE\">\r\n<!ENTITY % HTML4.dtd PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n%HTML4.dtd;";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testXMLInDTDFile() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<resources variant=\"\">\r\n    <resource name=\"res00\" >\r\n        <property name=\"propA\" value=\"...\" />\r\n        <property name=\"propB\" value=\"...\" />\r\n    </resource>\r\n</resources>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<resources variant=\"\">\r\n<resource name=\"res00\" >\r\n<property name=\"propA\" value=\"...\" />\r\n<property name=\"propB\" value=\"...\" />\r\n</resource>\r\n</resources>";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testBadDTDFile() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<![ %HTML.Reserved; [\r\n\r\n\r\n<!ENTITY % reserved\r\n \"datasrc     %URI;          #IMPLIED  -- \"\r\n  >\r\n\r\n]]>\r\n\r\n<!--=================== Text Markup ======================================-->";
        String expected = "<![ %HTML.Reserved; [\r\n<!ENTITY % reserved \"datasrc     %URI;          #IMPLIED  -- \">\r\n]]>\r\n<!--=================== Text Markup ======================================-->";
        XMLFormatterForDTDTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testIncompleteAttlistInternalDecl() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<!ATTLIST img src CDATA #REQUIRED %all;\r\n>\r\n\r\n<!-- Hypertext anchors. -->";
        String expected = "<!ATTLIST img\r\n  src CDATA #REQUIRED\r\n  %all;\r\n>\r\n<!-- Hypertext anchors. -->";
        XMLFormatterForDTDTest.assertDTDFormat(content, expected, settings, new TextEdit[0]);
    }

    private static void assertDTDFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterForDTDTest.assertDTDFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertDTDFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterForDTDTest.assertFormat(unformatted, expected, sharedSettings, "test.dtd", expectedEdits);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterForDTDTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterForDTDTest.assertFormat(unformatted, expected, sharedSettings, "test.xml", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterForDTDTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

