/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import com.google.gson.JsonObject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class DownloadDisabledResourceCodeAction
implements ICodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(DownloadDisabledResourceCodeAction.class.getName());
    private static final String URL_KEY = "url";
    private static final String FORCE_DOWNLOAD_TITLE = "Force download of ''{0}''.";

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        try {
            Range diagnosticRange = diagnostic.getRange();
            int start = document.offsetAt(diagnosticRange.getStart());
            int end = document.offsetAt(diagnosticRange.getEnd());
            String url = document.getText().substring(start, end);
            String title = MessageFormat.format(FORCE_DOWNLOAD_TITLE, url);
            CodeAction codeAction = new CodeAction(title);
            codeAction.setKind("quickfix");
            String documentURI = document.getDocumentURI();
            Command command = DownloadDisabledResourceCodeAction.createDownloadCommand(title, url, documentURI);
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Arrays.asList(diagnostic));
            codeActions.add(codeAction);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while creating download disabled resource code action.", e);
        }
    }

    public static Command createDownloadCommand(String title, String url, String documentURI) {
        JsonObject args = new JsonObject();
        args.addProperty(URL_KEY, url);
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(documentURI);
        List<Object> arguments = Arrays.asList(identifier, args);
        return new Command(title, "xml.validation.current.file", arguments);
    }

    public static String getUrlToForceToDownload(Map<String, Object> validationArgs) {
        if (validationArgs == null) {
            return null;
        }
        return (String)validationArgs.get(URL_KEY);
    }
}

