/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Objects;

public class PathPatternMatcher {
    private transient PathMatcher pathMatcher;
    private String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.pathMatcher = null;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public boolean matches(String uri) {
        try {
            return this.matches(new URI(uri));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matches(URI uri) {
        if (this.pattern.length() < 1) {
            return false;
        }
        if (this.pathMatcher == null) {
            char c = this.pattern.charAt(0);
            String glob = this.pattern;
            if (c != '*' && c != '?' && c != '/') {
                glob = "**/" + glob;
            }
            this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        }
        try {
            return this.pathMatcher.matches(Paths.get(uri));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathPatternMatcher) {
            PathPatternMatcher other = (PathPatternMatcher)obj;
            if (!Objects.equals(this.pathMatcher, other.getPathMatcher())) {
                return false;
            }
            return Objects.equals(this.pattern, other.getPattern());
        }
        return false;
    }
}

