/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import org.eclipse.lemminx.settings.FaultTolerantTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;

public class JSONUtility {
    private JSONUtility() {
    }

    public static <T> T toModel(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can not be null");
        }
        if (object instanceof JsonElement) {
            Gson gson = JSONUtility.getDefaultGsonBuilder().create();
            return (T)gson.fromJson((JsonElement)object, clazz);
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        return null;
    }

    private static GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new FaultTolerantTypeAdapterFactory());
    }
}

