/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.uriresolver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XMLCacheResolverExtension
implements URIResolverExtension {
    private final CacheResourcesManager cacheResourcesManager = new CacheResourcesManager();

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String url = resourceIdentifier.getExpandedSystemId();
        Path file = this.getCachedResource(url);
        if (file != null) {
            return new XMLFileInputSource(resourceIdentifier, file);
        }
        return null;
    }

    public Path getCachedResource(String url) throws IOException, CacheResourceDownloadedException {
        if (this.canUseCache(url)) {
            return this.cacheResourcesManager.getResource(url);
        }
        return null;
    }

    public boolean canUseCache(String url) {
        return this.cacheResourcesManager.canUseCache(url);
    }

    public void setUseCache(boolean useCache) {
        this.cacheResourcesManager.setUseCache(useCache);
    }

    public boolean isUseCache() {
        return this.cacheResourcesManager.isUseCache();
    }

    public boolean isDownloadExternalResources() {
        return this.cacheResourcesManager.isDownloadExternalResources();
    }

    public void setDownloadExternalResources(boolean downloadExternalResources) {
        this.cacheResourcesManager.setDownloadExternalResources(downloadExternalResources);
    }

    public void evictCache() throws IOException {
        this.cacheResourcesManager.evictCache();
    }

    private static class XMLFileInputSource
    extends XMLInputSource {
        private final Path file;

        public XMLFileInputSource(XMLResourceIdentifier resourceIdentifier, Path file) {
            super(resourceIdentifier);
            this.file = file;
        }

        public InputStream getByteStream() {
            InputStream input = super.getByteStream();
            if (input == null) {
                try {
                    super.setByteStream(Files.newInputStream(this.file, new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.getByteStream();
        }
    }
}

