/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.FileServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CacheResourcesManagerTest
extends AbstractCacheBasedTest {
    private CacheResourcesManager cacheResourcesManager;
    private FileServer server;

    @BeforeEach
    public void setup() throws Exception {
        this.cacheResourcesManager = new CacheResourcesManager(this.testingCache());
        this.cacheResourcesManager.setUseCache(true);
    }

    @AfterEach
    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testCanUseCache() {
        this.testCanUseCache(true);
        this.testCanUseCache(false);
    }

    private void testCanUseCache(boolean useCacheEnabled) {
        this.cacheResourcesManager.setUseCache(useCacheEnabled);
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("http://foo"));
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("ftp://foo"));
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("https://foo"));
        Assertions.assertFalse((boolean)this.cacheResourcesManager.canUseCache("file:///foo"));
    }

    @Test
    public void testUnavailableCache() throws Exception {
        FileServer server = new FileServer();
        server.start();
        String uri = server.getUri("bad/url");
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            block6: {
                try {
                    containsFuture.getFuture().get(30L, TimeUnit.SECONDS);
                    Assertions.fail((String)"Download should have failed");
                }
                catch (ExecutionException failedDownload) {
                    if (failedDownload.getCause() instanceof CacheResourceDownloadedException) break block6;
                    Assertions.fail((String)"Incorrect exception thrown during failed download");
                }
            }
            Assertions.assertNull((Object)this.cacheResourcesManager.getResource(uri));
        }
        TimeUnit.SECONDS.sleep(2L);
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy re-downloading the url");
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    @Test
    public void testAvailableCache() throws Exception {
        FileServer server = new FileServer();
        server.start();
        String uri = server.getUri("/dtd/web-app_2_3.dtd");
        Path path = null;
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            path = (Path)containsFuture.getFuture().get(30L, TimeUnit.SECONDS);
        }
        Assertions.assertNotNull((Object)path);
        Assertions.assertNotNull((Object)this.cacheResourcesManager.getResource(uri));
        server.stop();
        TimeUnit.SECONDS.sleep(2L);
        this.cacheResourcesManager.getResource(uri);
        Assertions.assertNotNull((Object)this.cacheResourcesManager.getResource(uri));
    }

    @Test
    public void testGetBadResource() throws IOException {
        CacheResourceDownloadingException actual = null;
        try {
            this.cacheResourcesManager.getResource("http://localhost/../../../../../test.txt");
        }
        catch (CacheResourceDownloadingException e) {
            actual = e;
        }
        Assertions.assertNotNull((Object)((Object)actual));
        Assertions.assertEquals((Object)"The resource 'http://localhost/../../../../../test.txt' cannot be downloaded in the cache path.", (Object)actual.getMessage());
    }

    private Cache<String, Boolean> testingCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).maximumSize(1L).build();
    }
}

