/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators.xml2dtd;

import java.io.IOException;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.xml2dtd.DTDGeneratorSettings;
import org.junit.jupiter.api.Test;

public class XML2DTDGeneratorTest {
    @Test
    public void dtd() throws IOException {
        String xml = "<note>\r\n\t<to>Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String dtd = "<!ELEMENT note (to,from,heading,body)>" + System.lineSeparator() + "<!ELEMENT to (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT from (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT heading (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT body (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void dtdWithAttr() throws IOException {
        String xml = "<note version=\"1.2\" >";
        String dtd = "<!ELEMENT note EMPTY>" + System.lineSeparator() + "<!ATTLIST note version NMTOKEN #REQUIRED>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void dtdWithAttrs() throws IOException {
        String xml = "<note version=\"1.2\" >\r\n\t<to attr1=\"abcd\" attr2=\"efgh\">Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String dtd = "<!ELEMENT note (to,from,heading,body)>" + System.lineSeparator() + "<!ATTLIST note version NMTOKEN #REQUIRED>" + System.lineSeparator() + "<!ELEMENT to (#PCDATA)>" + System.lineSeparator() + "<!ATTLIST to attr1 NMTOKEN #REQUIRED>" + System.lineSeparator() + "<!ATTLIST to attr2 NMTOKEN #REQUIRED>" + System.lineSeparator() + "<!ELEMENT from (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT heading (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT body (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void empty() throws IOException {
        String xml = "<note />";
        String dtd = "<!ELEMENT note EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void onlyCharacterContent() throws IOException {
        String xml = "<note>ABCD</note>";
        String dtd = "<!ELEMENT note (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void onlyElementChildren() throws IOException {
        String xml = "<note><from>ABCD</from></note>";
        String dtd = "<!ELEMENT note (from)>" + System.lineSeparator() + "<!ELEMENT from (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void characterContentAndElementChildren() throws IOException {
        String xml = "<note>ABCD<from>ABCD</from></note>";
        String dtd = "<!ELEMENT note (#PCDATA|from)*>" + System.lineSeparator() + "<!ELEMENT from (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void characterContentAndSeveralElementChildren() throws IOException {
        String xml = "<note><from>ABCD</from><to></to></note>";
        String dtd = "<!ELEMENT note (from,to)>" + System.lineSeparator() + "<!ELEMENT from (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT to EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void threeLevel() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c/>\r\n\t</b>\r\n</a>";
        String dtd = "<!ELEMENT a (b)>" + System.lineSeparator() + "<!ELEMENT b (c)>" + System.lineSeparator() + "<!ELEMENT c EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void severalSameElement() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c />\r\n\t\t<c />\r\n\t</b>\r\n\t<b />\r\n\t<b>\r\n\t\t<c />\r\n\t</b>\r\n</a>";
        String dtd = "<!ELEMENT a (b+)>" + System.lineSeparator() + "<!ELEMENT b (c*)>" + System.lineSeparator() + "<!ELEMENT c EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void cardinalityPlus() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c />\r\n\t\t<d />\r\n\t</b>\r\n\t<b>\r\n\t\t<c />\r\n\t\t<d />\r\n\t</b>\r\n</a>";
        String dtd = "<!ELEMENT a (b+)>" + System.lineSeparator() + "<!ELEMENT b (c,d)>" + System.lineSeparator() + "<!ELEMENT c EMPTY>" + System.lineSeparator() + "<!ELEMENT d EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void complexLevel() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<b>\r\n\t\t\t<d>X</d>\r\n\t\t</b>\r\n\t</b>\r\n\t<b>\r\n\t\t<c />\r\n\t</b>\r\n</a>";
        String dtd = "<!ELEMENT a (b+)>" + System.lineSeparator() + "<!ELEMENT b (b?,d?,c?)>" + System.lineSeparator() + "<!ELEMENT d (#PCDATA)>" + System.lineSeparator() + "<!ELEMENT c EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void mixedContent() {
        String xml = "<root>\r\n    <a>\r\n        <b>hello</b>\r\n        text\r\n    </a>\r\n</root>";
        String dtd = "<!ELEMENT root (a)>" + System.lineSeparator() + "<!ELEMENT a (#PCDATA|b)*>" + System.lineSeparator() + "<!ELEMENT b (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void mixedContentWith2SameElements() {
        String xml = "<root>\r\n\t<a>\r\n\t\t<b>hello</b>\r\n\t\ttext\r\n\t</a>\r\n\t<a>\r\n\t\ttext\r\n\t</a>\r\n</root>";
        String dtd = "<!ELEMENT root (a+)>" + System.lineSeparator() + "<!ELEMENT a (#PCDATA|b)*>" + System.lineSeparator() + "<!ELEMENT b (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void choice() {
        String xml = "<root>\r\n\t<a>\r\n\t\t<c />\r\n\t\t<b />\r\n\t</a>\r\n\t<a>\r\n\t\t<b />\r\n\t\t<c />\r\n\t</a>\r\n</root>";
        String dtd = "<!ELEMENT root (a+)>" + System.lineSeparator() + "<!ELEMENT a (c|b)*>" + System.lineSeparator() + "<!ELEMENT c EMPTY>" + System.lineSeparator() + "<!ELEMENT b EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void oneZero() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String dtd = "<!ELEMENT root (a+)>" + System.lineSeparator() + "<!ELEMENT a (b?)>" + System.lineSeparator() + "<!ELEMENT b EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void oneZero2() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a>\r\n        <c />\r\n    </a>\r\n    <a>\r\n        <b />\r\n        <c />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String dtd = "<!ELEMENT root (a+)>" + System.lineSeparator() + "<!ELEMENT a (b?,c?)>" + System.lineSeparator() + "<!ELEMENT b EMPTY>" + System.lineSeparator() + "<!ELEMENT c EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void optionalAttribute() {
        String xml = "<root>\r\n\t<item attr1=\"A\" attr2=\"B\"/>\r\n\t<item attr1=\"A\" />\r\n</root>";
        String dtd = "<!ELEMENT root (item+)>" + System.lineSeparator() + "<!ELEMENT item EMPTY>" + System.lineSeparator() + "<!ATTLIST item attr1 NMTOKEN #REQUIRED>" + System.lineSeparator() + "<!ATTLIST item attr2 NMTOKEN #IMPLIED>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void attrIDsAndFixed() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"A\" />\r\n\t<item attr1=\"id7\" attr2=\"A\" />\r\n\t<item attr1=\"id8\" attr2=\"A\" />\r\n\t<item attr1=\"id9\" attr2=\"A\" />\r\n\t<item attr1=\"id10\" attr2=\"A\" />\r\n</root>";
        String dtd = "<!ELEMENT root (item+)>" + System.lineSeparator() + "<!ELEMENT item EMPTY>" + System.lineSeparator() + "<!ATTLIST item attr1 ID #REQUIRED>" + System.lineSeparator() + "<!ATTLIST item attr2 NMTOKEN #FIXED \"A\">";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void attrIDsAndEnums() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"B\" />\r\n\t<item attr1=\"id7\" attr2=\"B\" />\r\n\t<item attr1=\"id8\" attr2=\"B\" />\r\n\t<item attr1=\"id9\" attr2=\"B\" />\r\n\t<item attr1=\"id10\" attr2=\"B\" />\r\n</root>";
        String dtd = "<!ELEMENT root (item+)>" + System.lineSeparator() + "<!ELEMENT item EMPTY>" + System.lineSeparator() + "<!ATTLIST item attr1 ID #REQUIRED>" + System.lineSeparator() + "<!ATTLIST item attr2 (A|B) #REQUIRED>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void invalidStartTag() throws IOException {
        String xml = "<a><</a>";
        String dtd = "<!ELEMENT a EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
        xml = "<a>bcd   <   </a>";
        dtd = "<!ELEMENT a (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }

    @Test
    public void invalidEndTag() throws IOException {
        String xml = "<a></</a>";
        String dtd = "<!ELEMENT a EMPTY>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
        xml = "<a>bcd   </   </a>";
        dtd = "<!ELEMENT a (#PCDATA)>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new DTDGeneratorSettings(), dtd);
    }
}

