/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.AbstractDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XSDDefinitionParticipant
extends AbstractDefinitionParticipant {
    @Override
    protected boolean match(DOMDocument document) {
        return DOMUtils.isXSD(document);
    }

    @Override
    protected void doFindDefinition(IDefinitionRequest request, List<LocationLink> locations, CancelChecker cancelChecker) {
        DOMNode node = request.getNode();
        if (!node.isAttribute()) {
            return;
        }
        DOMAttr attr = (DOMAttr)node;
        XSDUtils.BindingType bindingType = XSDUtils.getBindingType(attr);
        if (bindingType != XSDUtils.BindingType.NONE) {
            XSDUtils.searchXSTargetAttributes(attr, bindingType, true, true, (targetNamespacePrefix, targetAttr) -> {
                LocationLink location = XMLPositionUtility.createLocationLink(attr.getNodeAttrValue(), (DOMRange)targetAttr.getNodeAttrValue());
                locations.add(location);
            });
        }
    }
}

