/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.ExceptionUtils;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;

public class CacheResourcesManager {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String USER_AGENT_VALUE = "LemMinX";
    protected final Cache<String, Boolean> unavailableURICache;
    private static final String CACHE_PATH = "cache";
    private static final Logger LOGGER = Logger.getLogger(CacheResourcesManager.class.getName());
    private final Map<String, CompletableFuture<Path>> resourcesLoading = new HashMap<String, CompletableFuture<Path>>();
    private boolean useCache;
    private final Set<String> protocolsForCahe = new HashSet<String>();

    public CacheResourcesManager() {
        this((Cache<String, Boolean>)CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build());
    }

    public CacheResourcesManager(Cache<String, Boolean> cache) {
        this.unavailableURICache = cache;
        this.addDefaultProtocolsForCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getResource(String resourceURI) throws IOException {
        Path resourceCachePath = CacheResourcesManager.getResourceCachePath(resourceURI);
        if (Files.exists(resourceCachePath, new LinkOption[0])) {
            return resourceCachePath;
        }
        if (!FilesUtils.isIncludedInDeployedPath(resourceCachePath)) {
            throw new CacheResourceDownloadingException(resourceURI);
        }
        if (this.unavailableURICache.getIfPresent((Object)resourceURI) != null) {
            LOGGER.info("Ignored unavailable schema URI: " + resourceURI + "\n");
            return null;
        }
        CompletableFuture<Path> f = null;
        Map<String, CompletableFuture<Path>> map = this.resourcesLoading;
        synchronized (map) {
            if (this.resourcesLoading.containsKey(resourceURI)) {
                CompletableFuture<Path> future = this.resourcesLoading.get(resourceURI);
                throw new CacheResourceDownloadingException(resourceURI, future);
            }
            f = this.downloadResource(resourceURI, resourceCachePath);
            this.resourcesLoading.put(resourceURI, f);
        }
        if (f.getNow(null) == null) {
            throw new CacheResourceDownloadingException(resourceURI, f);
        }
        return resourceCachePath;
    }

    private CompletableFuture<Path> downloadResource(String resourceURI, Path resourceCachePath) {
        return CompletableFuture.supplyAsync(() -> {
            LOGGER.info("Downloading " + resourceURI + " to " + resourceCachePath + "...");
            long start = System.currentTimeMillis();
            URLConnection conn = null;
            try {
                Object actualURI = resourceURI;
                URL url = new URL((String)actualURI);
                conn = url.openConnection();
                conn.setRequestProperty(USER_AGENT_KEY, USER_AGENT_VALUE);
                for (int allowedRedirects = 5; conn.getHeaderField("Location") != null && allowedRedirects > 0; --allowedRedirects) {
                    actualURI = conn.getHeaderField("Location");
                    url = new URL((String)actualURI);
                    conn = url.openConnection();
                    conn.setRequestProperty(USER_AGENT_KEY, USER_AGENT_VALUE);
                }
                Path path = Files.createTempFile(resourceCachePath.getFileName().toString(), ".lemminx", new FileAttribute[0]);
                try (ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
                     FileOutputStream fos = new FileOutputStream(path.toFile());){
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                Path dir = resourceCachePath.getParent();
                if (!Files.exists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.move(path, resourceCachePath, new CopyOption[0]);
                long elapsed = System.currentTimeMillis() - start;
                LOGGER.info("Downloaded " + resourceURI + " to " + resourceCachePath + " in " + elapsed + "ms");
            }
            catch (Exception e) {
                this.unavailableURICache.put((Object)resourceURI, (Object)true);
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                String error = "[" + rootCause.getClass().getTypeName() + "] " + rootCause.getMessage();
                LOGGER.log(Level.SEVERE, "Error while downloading " + resourceURI + " to " + resourceCachePath + " : " + error);
                throw new CacheResourceDownloadedException("Error while downloading '" + resourceURI + "' to " + resourceCachePath + ".", e);
            }
            finally {
                Map<String, CompletableFuture<Path>> map = this.resourcesLoading;
                synchronized (map) {
                    this.resourcesLoading.remove(resourceURI);
                }
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
            return resourceCachePath;
        });
    }

    public static Path getResourceCachePath(String resourceURI) throws IOException {
        URI uri = URI.create(resourceURI);
        return CacheResourcesManager.getResourceCachePath(uri);
    }

    public static Path getResourceCachePath(URI uri) throws IOException {
        Path resourceCachePath = uri.getPort() > 0 ? Paths.get(CACHE_PATH, uri.getScheme(), uri.getHost(), String.valueOf(uri.getPort()), uri.getPath()) : Paths.get(CACHE_PATH, uri.getScheme(), uri.getHost(), uri.getPath());
        return FilesUtils.getDeployedPath(resourceCachePath);
    }

    public static Path getResourceCachePath(ResourceToDeploy resource) throws IOException {
        Path outFile = resource.getDeployedPath();
        if (!outFile.toFile().exists()) {
            try (InputStream in = CacheResourcesManager.class.getResourceAsStream(resource.getResourceFromClasspath());){
                FilesUtils.saveToFile(in, outFile);
            }
        }
        return outFile;
    }

    public boolean canUseCache(String url) {
        return this.isUseCache() && this.isUseCacheFor(url);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void evictCache() throws IOException {
        Path cachePath = FilesUtils.getDeployedPath(Paths.get(CACHE_PATH, new String[0]));
        if (Files.exists(cachePath, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)cachePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    public void addProtocolForCahe(String protocol) {
        this.protocolsForCahe.add(CacheResourcesManager.formatProtocol(protocol));
    }

    public void removeProtocolForCahe(String protocol) {
        this.protocolsForCahe.remove(CacheResourcesManager.formatProtocol(protocol));
    }

    private static String formatProtocol(String protocol) {
        if (!protocol.endsWith(":")) {
            return protocol + ":";
        }
        return protocol;
    }

    private boolean isUseCacheFor(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        for (String protocol : this.protocolsForCahe) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultProtocolsForCache() {
        this.addProtocolForCahe("http");
        this.addProtocolForCahe("https");
        this.addProtocolForCahe("ftp");
    }

    public static class ResourceToDeploy {
        private final Path resourceCachePath;
        private final String resourceFromClasspath;

        public ResourceToDeploy(String resourceURI, String resourceFromClasspath) {
            this(URI.create(resourceURI), resourceFromClasspath);
        }

        public ResourceToDeploy(URI resourceURI, String resourceFromClasspath) {
            this.resourceCachePath = Paths.get(CacheResourcesManager.CACHE_PATH, resourceURI.getScheme(), resourceURI.getHost(), resourceURI.getPath());
            this.resourceFromClasspath = resourceFromClasspath.startsWith("/") ? resourceFromClasspath : "/" + resourceFromClasspath;
        }

        public Path getDeployedPath() throws IOException {
            return FilesUtils.getDeployedPath(this.resourceCachePath);
        }

        public String getResourceFromClasspath() {
            return this.resourceFromClasspath;
        }
    }

    class ResourceInfo {
        String resourceURI;
        CompletableFuture<Path> future;

        ResourceInfo() {
        }
    }
}

