/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLRenameTest {
    @Test
    public void single() throws BadLocationException {
        XMLAssert.assertRename("|<html></html>", "newText");
        XMLAssert.assertRename("<|html></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<h|tml></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<htm|l></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html|></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html>|</html>", "newText");
        XMLAssert.assertRename("<html><|/html>", "newText");
        XMLAssert.assertRename("<html></|html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html></h|tml>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html></ht|ml>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html></htm|l>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html></html|>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 8, 12)));
        XMLAssert.assertRename("<html></html>|", "newText");
    }

    @Test
    public void nested() throws BadLocationException {
        XMLAssert.assertRename("<html>|<div></div></html>", "newText");
        XMLAssert.assertRename("<html><|div></div></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10), XMLRenameTest.r(0, 13, 16)));
        XMLAssert.assertRename("<html><div>|</div></html>", "newText");
        XMLAssert.assertRename("<html><div></di|v></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10), XMLRenameTest.r(0, 13, 16)));
        XMLAssert.assertRename("<html><div><div></div></di|v></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10), XMLRenameTest.r(0, 24, 27)));
        XMLAssert.assertRename("<html><div><div></div|></div></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 12, 15), XMLRenameTest.r(0, 18, 21)));
        XMLAssert.assertRename("<html><div><div|></div></div></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 12, 15), XMLRenameTest.r(0, 18, 21)));
        XMLAssert.assertRename("<html><div><div></div></div></h|tml>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 30, 34)));
        XMLAssert.assertRename("<html><di|v></div><div></div></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10), XMLRenameTest.r(0, 13, 16)));
        XMLAssert.assertRename("<html><div></div><div></d|iv></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 18, 21), XMLRenameTest.r(0, 24, 27)));
    }

    @Test
    public void selfclosed() throws BadLocationException {
        XMLAssert.assertRename("<html><|div/></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10)));
        XMLAssert.assertRename("<html><|br></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 9)));
        XMLAssert.assertRename("<html><div><d|iv/></div></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 12, 15)));
    }

    @Test
    public void caseSensitive() throws BadLocationException {
        XMLAssert.assertRename("<HTML><diV><Div></dIV></dI|v></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 24, 27)));
        XMLAssert.assertRename("<HTML><diV|><Div></dIV></dIv></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 7, 10)));
    }

    @Test
    public void insideEndTag() throws BadLocationException {
        XMLAssert.assertRename("<html|></meta></html>", "newText", XMLRenameTest.edits("newText", XMLRenameTest.r(0, 1, 5), XMLRenameTest.r(0, 15, 19)));
    }

    @Test
    public void testNamespaceRename() throws BadLocationException {
        String xml = "<aa:a xmlns:a|a=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n  <aa:b></aa:b>\n  <aa:c/>\n  <t type=\"aa:b\"/>\n  <qq:b></qq:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "ns", XMLRenameTest.edits("ns", XMLRenameTest.r(0, 12, 14), XMLRenameTest.r(0, 1, 3), XMLRenameTest.r(6, 2, 4), XMLRenameTest.r(1, 3, 5), XMLRenameTest.r(1, 10, 12), XMLRenameTest.r(2, 3, 5), XMLRenameTest.r(2, 10, 12), XMLRenameTest.r(3, 3, 5), XMLRenameTest.r(4, 11, 13)));
    }

    @Test
    public void testNamespaceRenameEndTagPrefix() throws BadLocationException {
        String xml = "<aa:a xmlns:aa=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n  <aa:b></a|a:b>\n  <aa:c/>\n  <t type=\"aa:b\"/>\n  <qq:b></qq:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "ns", XMLRenameTest.edits("ns", XMLRenameTest.r(2, 3, 5), XMLRenameTest.r(2, 10, 12)));
    }

    @Test
    public void testNamespaceRenameStartTagPrefix() throws BadLocationException {
        String xml = "<aa:a xmlns:aa=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n  <a|a:b></aa:b>\n  <aa:c/>\n  <t type=\"aa:b\"/>\n  <qq:b></qq:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "ns", XMLRenameTest.edits("ns", XMLRenameTest.r(2, 3, 5), XMLRenameTest.r(2, 10, 12)));
    }

    @Test
    public void testNamespaceRenameEndTagSuffix() throws BadLocationException {
        String xml = "<aa:a xmlns:aa=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n  <aa:|b></aa:b>\n  <aa:c/>\n  <t type=\"aa:b\"/>\n  <qq:b></qq:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "BB", XMLRenameTest.edits("BB", XMLRenameTest.r(2, 6, 7), XMLRenameTest.r(2, 13, 14)));
    }

    @Test
    public void testNamespaceRenameStartTagSuffix() throws BadLocationException {
        String xml = "<aa:a xmlns:aa=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n  <aa:b></aa:b|>\n  <aa:c/>\n  <t type=\"aa:b\"/>\n  <qq:b></qq:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "BB", XMLRenameTest.edits("BB", XMLRenameTest.r(2, 6, 7), XMLRenameTest.r(2, 13, 14)));
    }

    @Test
    public void testTryToRenameXMLNS() throws BadLocationException {
        String xml = "<aa:a xml|ns:aa=\"aa.com\" xmlns:qq=\"qq.com\">\n  <aa:b></aa:b>\n</aa:a>";
        XMLAssert.assertRename(xml, "BBBB");
    }

    private static Range r(int line, int startCharacter, int endCharacter) {
        return new Range(new Position(line, startCharacter), new Position(line, endCharacter));
    }

    private static List<TextEdit> edits(String newText, Range ... ranges) {
        return Stream.of(ranges).map(r -> new TextEdit(r, newText)).collect(Collectors.toList());
    }
}

