/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.io.IOException;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XMLCatalogURIResolverExtension
implements URIResolverExtension {
    private static final String CATALOG_NAMESPACE_URI = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String CATALOG_SYSTEM = "http://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd";
    private final XMLExtensionsRegistry extensionsRegistry;

    @Override
    public String getName() {
        return "embedded catalog.xsd";
    }

    public XMLCatalogURIResolverExtension(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        if (!CATALOG_NAMESPACE_URI.equals(publicId)) {
            return null;
        }
        if (this.hasDTDorXMLSchema(baseLocation)) {
            return null;
        }
        return CATALOG_SYSTEM;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        if (this.hasDTDorXMLSchema(resourceIdentifier.getBaseSystemId())) {
            return null;
        }
        String publicId = resourceIdentifier.getNamespace();
        if (CATALOG_NAMESPACE_URI.equals(publicId)) {
            return new XMLInputSource(publicId, CATALOG_SYSTEM, CATALOG_SYSTEM);
        }
        return null;
    }

    private boolean hasDTDorXMLSchema(String uri) {
        DOMDocument document = this.extensionsRegistry.getDocumentProvider().getDocument(uri);
        if (document == null) {
            return false;
        }
        return document.hasDTD() || document.hasSchemaLocation() || document.hasNoNamespaceSchemaLocation();
    }
}

