/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLDiagnostics {
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLDiagnostics(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<Diagnostic> doDiagnostics(DOMDocument xmlDocument, XMLValidationSettings validationSettings, CancelChecker cancelChecker) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (validationSettings == null || validationSettings.isEnabled()) {
            this.doExtensionsDiagnostics(xmlDocument, diagnostics, validationSettings, cancelChecker);
        }
        return diagnostics;
    }

    private void doExtensionsDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker monitor) {
        for (IDiagnosticsParticipant diagnosticsParticipant : this.extensionsRegistry.getDiagnosticsParticipants()) {
            monitor.checkCanceled();
            diagnosticsParticipant.doDiagnostics(xmlDocument, diagnostics, validationSettings, monitor);
        }
    }
}

