/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.client.LimitExceededWarnings;
import org.eclipse.lemminx.client.LimitFeature;
import org.eclipse.lemminx.commons.ModelTextDocument;
import org.eclipse.lemminx.commons.ModelTextDocuments;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.commons.TextDocuments;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.AbstractSaveContext;
import org.eclipse.lemminx.settings.CompositeSettings;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLPreferences;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class XMLTextDocumentService
implements TextDocumentService {
    private final XMLLanguageServer xmlLanguageServer;
    private final TextDocuments<ModelTextDocument<DOMDocument>> documents;
    private SharedSettings sharedSettings;
    private LimitExceededWarnings limitExceededWarnings;
    final ScheduledExecutorService delayer = Executors.newScheduledThreadPool(2);
    private boolean codeActionLiteralSupport;
    private boolean hierarchicalDocumentSymbolSupport;
    private boolean definitionLinkSupport;
    private boolean typeDefinitionLinkSupport;

    public XMLTextDocumentService(XMLLanguageServer xmlLanguageServer) {
        this.xmlLanguageServer = xmlLanguageServer;
        DOMParser parser = DOMParser.getInstance();
        this.documents = new ModelTextDocuments<DOMDocument>((document, cancelChecker) -> parser.parse((TextDocument)((Object)document), this.getXMLLanguageService().getResolverExtensionManager(), true, (CancelChecker)cancelChecker));
        this.sharedSettings = new SharedSettings();
        this.limitExceededWarnings = null;
    }

    public void updateClientCapabilities(ClientCapabilities capabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
        if (textDocumentClientCapabilities != null) {
            this.sharedSettings.getCompletionSettings().setCapabilities(textDocumentClientCapabilities.getCompletion());
            this.sharedSettings.getFoldingSettings().setCapabilities(textDocumentClientCapabilities.getFoldingRange());
            this.sharedSettings.getHoverSettings().setCapabilities(textDocumentClientCapabilities.getHover());
            this.codeActionLiteralSupport = textDocumentClientCapabilities.getCodeAction() != null && textDocumentClientCapabilities.getCodeAction().getCodeActionLiteralSupport() != null;
            this.hierarchicalDocumentSymbolSupport = textDocumentClientCapabilities.getDocumentSymbol() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != false;
            this.definitionLinkSupport = textDocumentClientCapabilities.getDefinition() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != false;
            boolean bl = this.typeDefinitionLinkSupport = textDocumentClientCapabilities.getTypeDefinition() != null && textDocumentClientCapabilities.getTypeDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getTypeDefinition().getLinkSupport() != false;
        }
        if (extendedClientCapabilities != null) {
            this.sharedSettings.getCodeLensSettings().setCodeLens(extendedClientCapabilities.getCodeLens());
            this.sharedSettings.setActionableNotificationSupport(extendedClientCapabilities.isActionableNotificationSupport());
            this.sharedSettings.setOpenSettingsCommandSupport(extendedClientCapabilities.isOpenSettingsCommandSupport());
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> {
            CompletionList list = this.getXMLLanguageService().doComplete((DOMDocument)xmlDocument, params.getPosition(), this.sharedSettings, (CancelChecker)cancelChecker);
            return Either.forRight((Object)list);
        });
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().doHover((DOMDocument)xmlDocument, params.getPosition(), this.sharedSettings, (CancelChecker)cancelChecker));
    }

    private XMLFormattingOptions getFormattingSettings(String uri) {
        return this.sharedSettings.getFormattingSettings();
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().findDocumentHighlights((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        ModelTextDocument<DOMDocument> document = this.getDocument(params.getTextDocument().getUri());
        XMLSymbolSettings symbolSettings = this.sharedSettings.getSymbolSettings();
        if (!symbolSettings.isEnabled() || symbolSettings.isExcluded(document.getUri())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> {
            ArrayList result;
            boolean resultLimitExceeded = false;
            List symbols = null;
            if (this.hierarchicalDocumentSymbolSupport) {
                result = this.getXMLLanguageService().findDocumentSymbols((DOMDocument)xmlDocument, symbolSettings, (CancelChecker)cancelChecker);
                resultLimitExceeded = ((DocumentSymbolsResult)result).isResultLimitExceeded();
                symbols = result.stream().map(s -> {
                    Either e = Either.forRight((Object)s);
                    return e;
                }).collect(Collectors.toList());
            }
            result = this.getXMLLanguageService().findSymbolInformations((DOMDocument)xmlDocument, symbolSettings, (CancelChecker)cancelChecker);
            resultLimitExceeded = ((SymbolInformationResult)result).isResultLimitExceeded();
            symbols = result.stream().map(s -> {
                Either e = Either.forLeft((Object)s);
                return e;
            }).collect(Collectors.toList());
            if (resultLimitExceeded) {
                this.getLimitExceededWarnings().onResultLimitExceeded(xmlDocument.getTextDocument().getUri(), LimitFeature.SYMBOLS);
            }
            return symbols;
        });
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            String uri = params.getTextDocument().getUri();
            ModelTextDocument<DOMDocument> document = this.getDocument(uri);
            CompositeSettings settings = new CompositeSettings(this.getSharedSettings(), params.getOptions());
            return this.getXMLLanguageService().format(document, null, settings);
        });
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            String uri = params.getTextDocument().getUri();
            ModelTextDocument<DOMDocument> document = this.getDocument(uri);
            CompositeSettings settings = new CompositeSettings(this.getSharedSettings(), params.getOptions());
            return this.getXMLLanguageService().format(document, params.getRange(), settings);
        });
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().doRename((DOMDocument)xmlDocument, params.getPosition(), params.getNewName()));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        ModelTextDocument<DOMDocument> document = this.documents.onDidOpenTextDocument(params);
        this.triggerValidationFor(document);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        ModelTextDocument<DOMDocument> document = this.documents.onDidChangeTextDocument(params);
        this.triggerValidationFor(document);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documents.onDidCloseTextDocument(params);
        TextDocumentIdentifier document = params.getTextDocument();
        String uri = document.getUri();
        this.xmlLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, Collections.emptyList()));
        this.getLimitExceededWarnings().evict(uri);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().getFoldingRanges((DOMDocument)xmlDocument, this.sharedSettings.getFoldingSettings(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().findDocumentLinks((DOMDocument)xmlDocument));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> {
            if (this.definitionLinkSupport) {
                return Either.forRight(this.getXMLLanguageService().findDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
            }
            List locations = this.getXMLLanguageService().findDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker).stream().map(locationLink -> XMLPositionUtility.toLocation(locationLink)).collect(Collectors.toList());
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> {
            if (this.typeDefinitionLinkSupport) {
                return Either.forRight(this.getXMLLanguageService().findTypeDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
            }
            List locations = this.getXMLLanguageService().findTypeDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker).stream().map(locationLink -> XMLPositionUtility.toLocation(locationLink)).collect(Collectors.toList());
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().findReferences((DOMDocument)xmlDocument, params.getPosition(), params.getContext(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (!this.sharedSettings.getCodeLensSettings().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().getCodeLens((DOMDocument)xmlDocument, this.sharedSettings.getCodeLensSettings(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> {
            String uri = params.getTextDocument().getUri();
            return this.getXMLLanguageService().doCodeActions(params.getContext(), params.getRange(), (DOMDocument)xmlDocument, this.sharedSettings).stream().map(ca -> {
                if (this.codeActionLiteralSupport) {
                    Either e = Either.forRight((Object)ca);
                    return e;
                }
                List<Object> arguments = Arrays.asList(uri, xmlDocument.getTextDocument().getVersion(), ((TextDocumentEdit)((Either)ca.getEdit().getDocumentChanges().get(0)).getLeft()).getEdits());
                Command command = new Command(ca.getTitle(), "_xml.applyCodeAction", arguments);
                Either e = Either.forLeft((Object)command);
                return e;
            }).collect(Collectors.toList());
        });
    }

    public void didSave(DidSaveTextDocumentParams params) {
        CompletableFutures.computeAsync(monitor -> {
            SaveContext context = new SaveContext(params.getTextDocument().getUri());
            this.doSave(context);
            return null;
        });
    }

    public void updateSettings(Object settings) {
        SaveContext context = new SaveContext(settings);
        this.doSave(context);
    }

    void doSave(String uri) {
        SaveContext context = new SaveContext(uri);
        this.doSave(context);
    }

    void doSave(SaveContext context) {
        this.getXMLLanguageService().doSave(context);
        context.triggerValidationIfNeeded();
    }

    private void triggerValidationFor(Collection<ModelTextDocument<DOMDocument>> documents) {
        if (!documents.isEmpty()) {
            this.xmlLanguageServer.schedule(() -> documents.forEach(document -> {
                try {
                    this.validate(document.getModel().getNow(null));
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }), 500, TimeUnit.MILLISECONDS);
        }
    }

    private void triggerValidationFor(TextDocument document) {
        ((ModelTextDocument)document).getModel().thenAcceptAsync(xmlDocument -> this.validate((DOMDocument)xmlDocument));
    }

    private void validate(DOMDocument xmlDocument) throws CancellationException {
        CancelChecker cancelChecker = xmlDocument.getCancelChecker();
        cancelChecker.checkCanceled();
        this.getXMLLanguageService().publishDiagnostics(xmlDocument, params -> this.xmlLanguageServer.getLanguageClient().publishDiagnostics((PublishDiagnosticsParams)params), doc -> this.triggerValidationFor((TextDocument)((Object)doc)), this.sharedSettings.getValidationSettings(), cancelChecker);
    }

    private XMLLanguageService getXMLLanguageService() {
        return this.xmlLanguageServer.getXMLLanguageService();
    }

    public void updateCompletionSettings(XMLCompletionSettings newCompletion) {
        this.sharedSettings.getCompletionSettings().merge(newCompletion);
    }

    public void updateSymbolSettings(XMLSymbolSettings newSettings) {
        this.sharedSettings.getSymbolSettings().merge(newSettings);
    }

    public void updateCodeLensSettings(XMLCodeLensSettings newSettings) {
        this.sharedSettings.getCodeLensSettings().merge(newSettings);
    }

    public void updatePreferences(XMLPreferences newPreferences) {
        this.sharedSettings.getPreferences().merge(newPreferences);
    }

    public XMLSymbolSettings getSharedSymbolSettings() {
        return this.sharedSettings.getSymbolSettings();
    }

    public XMLCodeLensSettings getSharedCodeLensSettings() {
        return this.sharedSettings.getCodeLensSettings();
    }

    public boolean isIncrementalSupport() {
        return this.documents.isIncremental();
    }

    public XMLFormattingOptions getSharedFormattingSettings() {
        return this.sharedSettings.getFormattingSettings();
    }

    public XMLValidationSettings getValidationSettings() {
        return this.sharedSettings.getValidationSettings();
    }

    public XMLPreferences getPreferences() {
        return this.sharedSettings.getPreferences();
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    public ModelTextDocument<DOMDocument> getDocument(String uri) {
        return this.documents.get(uri);
    }

    public boolean documentIsOpen(String uri) {
        ModelTextDocument<DOMDocument> document = this.getDocument(uri);
        return document != null;
    }

    public <R> CompletableFuture<R> computeDOMAsync(TextDocumentIdentifier documentIdentifier, BiFunction<CancelChecker, DOMDocument, R> code) {
        return XMLTextDocumentService.computeModelAsync(this.getDocument(documentIdentifier.getUri()).getModel(), code);
    }

    private static <R, M> CompletableFuture<R> computeModelAsync(CompletableFuture<M> loadModel, BiFunction<CancelChecker, M, R> code) {
        CompletableFuture<CancelChecker> start = new CompletableFuture<CancelChecker>();
        CompletionStage result = start.thenCombineAsync(loadModel, code);
        CancelChecker cancelIndicator = () -> XMLTextDocumentService.lambda$computeModelAsync$26((CompletableFuture)result);
        start.complete(cancelIndicator);
        return result;
    }

    public LimitExceededWarnings getLimitExceededWarnings() {
        if (this.limitExceededWarnings == null) {
            this.limitExceededWarnings = new LimitExceededWarnings(this.xmlLanguageServer.getLanguageClient(), this.sharedSettings);
        }
        return this.limitExceededWarnings;
    }

    private static /* synthetic */ void lambda$computeModelAsync$26(CompletableFuture result) {
        if (result.isCancelled()) {
            throw new CancellationException();
        }
    }

    class SaveContext
    extends AbstractSaveContext {
        private final Collection<ModelTextDocument<DOMDocument>> documentsToValidate;

        public SaveContext(Object settings) {
            super(settings);
            this.documentsToValidate = new ArrayList<ModelTextDocument<DOMDocument>>();
        }

        public SaveContext(String uri) {
            super(uri);
            this.documentsToValidate = new ArrayList<ModelTextDocument<DOMDocument>>();
        }

        @Override
        public void collectDocumentToValidate(Predicate<DOMDocument> validateDocumentPredicate) {
            XMLTextDocumentService.this.documents.all().stream().forEach(document -> {
                DOMDocument xmlDocument = document.getModel().getNow(null);
                if (xmlDocument != null && !this.documentsToValidate.contains(document) && validateDocumentPredicate.test(xmlDocument)) {
                    this.documentsToValidate.add((ModelTextDocument<DOMDocument>)((Object)document));
                }
            });
        }

        @Override
        public DOMDocument getDocument(String uri) {
            return XMLTextDocumentService.this.xmlLanguageServer.getDocument(uri);
        }

        public void triggerValidationIfNeeded() {
            XMLTextDocumentService.this.triggerValidationFor(this.documentsToValidate);
        }
    }
}

