/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.util.List;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.xerces.LSPMessageFormatter;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public abstract class AbstractLSPErrorReporter
extends XMLErrorReporter {
    private final DOMDocument xmlDocument;
    private final List<Diagnostic> diagnostics;
    private final String source;

    public AbstractLSPErrorReporter(String source, DOMDocument xmlDocument, List<Diagnostic> diagnostics) {
        this.source = source;
        this.xmlDocument = xmlDocument;
        this.diagnostics = diagnostics;
        XMLMessageFormatter xmft = new XMLMessageFormatter();
        super.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)xmft);
        super.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)xmft);
        super.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)new LSPMessageFormatter());
    }

    public String reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity, Exception exception) throws XNIException {
        String message;
        MessageFormatter messageFormatter = this.getMessageFormatter(domain);
        if (messageFormatter != null) {
            message = messageFormatter.formatMessage(this.fLocale, key, arguments);
        } else {
            int argCount;
            StringBuilder str = new StringBuilder();
            str.append(domain);
            str.append('#');
            str.append(key);
            int n = argCount = arguments != null ? arguments.length : 0;
            if (argCount > 0) {
                str.append('?');
                for (int i = 0; i < argCount; ++i) {
                    str.append(arguments[i]);
                    if (i >= argCount - 1) continue;
                    str.append('&');
                }
            }
            message = str.toString();
        }
        Range adjustedRange = this.internalToLSPRange(location, key, arguments, this.xmlDocument);
        if (adjustedRange == null) {
            return null;
        }
        if (!this.addDiagnostic(adjustedRange, message, AbstractLSPErrorReporter.toLSPSeverity(severity), key)) {
            return null;
        }
        if (severity == 2 && !this.fContinueAfterFatalError && !this.isIgnoreFatalError(key)) {
            XMLParseException parseException = exception != null ? new XMLParseException(location, message, exception) : new XMLParseException(location, message);
            throw parseException;
        }
        return message;
    }

    protected boolean isIgnoreFatalError(String key) {
        return false;
    }

    public boolean addDiagnostic(Range adjustedRange, String message, DiagnosticSeverity severity, String key) {
        Diagnostic d = new Diagnostic(adjustedRange, message, severity, this.source, key);
        if (this.diagnostics.contains(d)) {
            return false;
        }
        this.diagnostics.add(d);
        return true;
    }

    private static DiagnosticSeverity toLSPSeverity(int severity) {
        switch (severity) {
            case 0: {
                return DiagnosticSeverity.Warning;
            }
        }
        return DiagnosticSeverity.Error;
    }

    private Range internalToLSPRange(XMLLocator location, String key, Object[] arguments, DOMDocument document) {
        if (location == null) {
            Position start = AbstractLSPErrorReporter.toLSPPosition(0, location, document.getTextDocument());
            Position end = AbstractLSPErrorReporter.toLSPPosition(0, location, document.getTextDocument());
            return new Range(start, end);
        }
        Range range = this.toLSPRange(location, key, arguments, document);
        if (range != null) {
            return range;
        }
        int startOffset = location.getCharacterOffset() - 1;
        int endOffset = location.getCharacterOffset() - 1;
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        Position start = AbstractLSPErrorReporter.toLSPPosition(startOffset, location, document.getTextDocument());
        Position end = AbstractLSPErrorReporter.toLSPPosition(endOffset, location, document.getTextDocument());
        return new Range(start, end);
    }

    protected abstract Range toLSPRange(XMLLocator var1, String var2, Object[] var3, DOMDocument var4);

    private static Position toLSPPosition(int offset, XMLLocator location, TextDocument document) {
        if (location != null && offset == location.getCharacterOffset() - 1) {
            return new Position(location.getLineNumber() - 1, location.getColumnNumber() - 1);
        }
        try {
            return document.positionAt(offset);
        }
        catch (BadLocationException e) {
            return location != null ? new Position(location.getLineNumber() - 1, location.getColumnNumber() - 1) : null;
        }
    }
}

