/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class MarkupEntityMismatchCodeAction
implements ICodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(MarkupEntityMismatchCodeAction.class.getName());

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, XMLFormattingOptions formattingSettings, IComponentProvider componentProvider) {
        MarkupEntityMismatchCodeAction.createEndTagInsertCodeAction(diagnostic, range, document, codeActions, formattingSettings, componentProvider);
    }

    public static void createEndTagInsertCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, XMLFormattingOptions formattingSettings, IComponentProvider componentProvider) {
        try {
            Position endPosition;
            int offset = document.offsetAt(diagnostic.getRange().getStart());
            DOMNode node = document.findNodeAt(offset);
            if (!node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            int startOffset = element.getStartTagOpenOffset();
            if (startOffset == -1) {
                return;
            }
            Position startPosition = document.positionAt(startOffset);
            XMLSyntaxErrorCode code = XMLSyntaxErrorCode.get(diagnostic.getCode());
            switch (code) {
                case MarkupEntityMismatch: {
                    endPosition = document.positionAt(document.getEnd());
                    if (endPosition.getLine() <= startPosition.getLine()) break;
                    endPosition.setCharacter(startPosition.getCharacter());
                    break;
                }
                case ETagRequired: {
                    endPosition = document.positionAt(element.getStartTagCloseOffset() + 1);
                    break;
                }
                default: {
                    return;
                }
            }
            String elementName = element.getTagName();
            CodeAction action = CodeActionFactory.insert("Close with '</" + elementName + ">'", endPosition, "</" + elementName + ">", document.getTextDocument(), diagnostic);
            codeActions.add(action);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.WARNING, "Exception while resolving the code action for " + diagnostic.getCode() + ":", e);
        }
    }
}

