/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.extensions.xsi.XSISchemaModel;
import org.eclipse.lemminx.services.extensions.HoverParticipantAdapter;
import org.eclipse.lemminx.services.extensions.IHoverRequest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lsp4j.MarkupContent;

public class ContentModelHoverParticipant
extends HoverParticipantAdapter {
    @Override
    public String onTag(IHoverRequest hoverRequest) throws Exception {
        try {
            MarkupContent content;
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            DOMElement node = (DOMElement)hoverRequest.getNode();
            CMElementDeclaration cmElement = contentModelManager.findCMElement(node);
            if (cmElement != null && (content = XMLGenerator.createMarkupContent(cmElement, hoverRequest)) != null) {
                return content.getValue();
            }
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
        return null;
    }

    @Override
    public String onAttributeName(IHoverRequest hoverRequest) throws Exception {
        DOMAttr attribute = (DOMAttr)hoverRequest.getNode();
        try {
            MarkupContent content;
            String attributeName;
            CMAttributeDeclaration cmAttribute;
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            CMElementDeclaration cmElement = contentModelManager.findCMElement(attribute.getOwnerElement());
            if (cmElement != null && (cmAttribute = cmElement.findCMAttribute(attributeName = attribute.getName())) != null && (content = XMLGenerator.createMarkupContent(cmAttribute, cmElement, hoverRequest)) != null) {
                return content.getValue();
            }
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
        return null;
    }

    @Override
    public String onAttributeValue(IHoverRequest hoverRequest) throws Exception {
        DOMAttr attribute = (DOMAttr)hoverRequest.getNode();
        String temp = XSISchemaModel.computeHoverResponse(attribute, hoverRequest);
        if (temp != null) {
            return temp;
        }
        try {
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            CMElementDeclaration cmElement = contentModelManager.findCMElement(attribute.getOwnerElement());
            if (cmElement != null) {
                MarkupContent content;
                String attributeName = attribute.getName();
                CMAttributeDeclaration cmAttribute = cmElement.findCMAttribute(attributeName);
                String attributeValue = attribute.getValue();
                if (cmAttribute != null && (content = XMLGenerator.createMarkupContent(cmAttribute, attributeValue, cmElement, hoverRequest)) != null) {
                    return content.getValue();
                }
            }
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
        return null;
    }

    private static String getCacheWarningHover(CacheResourceDownloadingException e, MarkupContentFactory.IMarkupKindSupport support) {
        MarkupContent content = MarkupContentFactory.createMarkupContent("Cannot process " + (e.isDTD() ? "DTD" : "XML Schema") + " hover: " + e.getMessage(), "markdown", support);
        return content.getValue();
    }
}

