/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLBuilder {
    private final XMLFormattingOptions formattingOptions;
    private final String lineDelimiter;
    private final StringBuilder xml;
    private final String whitespacesIndent;
    private final int splitAttributesIndent = 2;

    public XMLBuilder(XMLFormattingOptions formattingOptions, String whitespacesIndent, String lineDelimiter) {
        this.whitespacesIndent = whitespacesIndent;
        this.formattingOptions = formattingOptions != null ? formattingOptions : new XMLFormattingOptions(true);
        this.lineDelimiter = lineDelimiter;
        this.xml = new StringBuilder();
    }

    public XMLBuilder appendSpace() {
        this.xml.append(" ");
        return this;
    }

    public XMLBuilder startElement(String prefix, String name, boolean close) {
        this.xml.append("<");
        if (prefix != null && !prefix.isEmpty()) {
            this.xml.append(prefix);
            this.xml.append(":");
        }
        this.xml.append(name);
        if (close) {
            this.closeStartElement();
        }
        return this;
    }

    public XMLBuilder startElement(String name, boolean close) {
        return this.startElement(null, name, close);
    }

    public XMLBuilder endElement(String name, boolean isEndTagClosed) {
        return this.endElement(null, name, isEndTagClosed);
    }

    public XMLBuilder endElement(String name) {
        return this.endElement(null, name, true);
    }

    public XMLBuilder endElement(String prefix, String name) {
        return this.endElement(prefix, name, true);
    }

    public XMLBuilder endElement(String prefix, String name, boolean isEndTagClosed) {
        this.xml.append("</");
        if (prefix != null && !prefix.isEmpty()) {
            this.xml.append(prefix);
            this.xml.append(":");
        }
        this.xml.append(name);
        if (isEndTagClosed) {
            this.xml.append(">");
        }
        return this;
    }

    public XMLBuilder closeStartElement() {
        this.xml.append(">");
        return this;
    }

    public XMLBuilder selfCloseElement() {
        if (this.formattingOptions.isSpaceBeforeEmptyCloseTag()) {
            this.xml.append(" ");
        }
        this.xml.append("/>");
        return this;
    }

    public XMLBuilder addSingleAttribute(String name, String value) {
        return this.addSingleAttribute(name, value, false);
    }

    public XMLBuilder addSingleAttribute(String name, String value, boolean surroundWithQuotes) {
        this.xml.append(" ");
        this.addAttributeContents(name, true, value, surroundWithQuotes);
        return this;
    }

    public XMLBuilder addAttributesOnSingleLine(DOMAttr attr, Boolean surroundWithQuotes) {
        this.xml.append(" ");
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getValue(), surroundWithQuotes);
        return this;
    }

    public XMLBuilder addAttribute(String name, String value, int level) {
        return this.addAttribute(name, value, level, false);
    }

    public XMLBuilder addAttribute(String name, String value, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + 2);
        } else {
            this.xml.append(" ");
        }
        this.addAttributeContents(name, true, value, surroundWithQuotes);
        return this;
    }

    public XMLBuilder addAttribute(DOMAttr attr, int level) {
        return this.addAttribute(attr, level, false);
    }

    public XMLBuilder addAttribute(DOMAttr attr, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + 2);
        } else {
            this.xml.append(" ");
        }
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getOriginalValue(), surroundWithQuotes);
        return this;
    }

    private void addAttributeContents(String name, Boolean equalsSign, String originalValue, boolean surroundWithQuotes) {
        if (name != null) {
            this.xml.append(name);
        }
        if (equalsSign.booleanValue()) {
            this.xml.append("=");
        }
        if (originalValue != null) {
            String quote;
            String string = quote = this.formattingOptions.isQuotations("doubleQuotes") ? "\"" : "'";
            if (DOMAttr.isQuoted(originalValue)) {
                if (originalValue.charAt(0) == '\'' && this.formattingOptions.isQuotations("doubleQuotes") || originalValue.charAt(0) == '\"' && this.formattingOptions.isQuotations("singleQuotes")) {
                    originalValue = DOMAttr.convertToQuotelessValue(originalValue);
                    this.xml.append(quote);
                    if (originalValue != null) {
                        this.xml.append(originalValue);
                    }
                    this.xml.append(quote);
                    return;
                }
                this.xml.append(originalValue);
                return;
            }
            if (surroundWithQuotes) {
                this.xml.append(quote);
                if (originalValue != null) {
                    this.xml.append(originalValue);
                }
                this.xml.append(quote);
                return;
            }
            this.xml.append(originalValue);
        }
    }

    public XMLBuilder linefeed() {
        this.xml.append(this.lineDelimiter);
        if (this.whitespacesIndent != null) {
            this.xml.append(this.whitespacesIndent);
        }
        return this;
    }

    public XMLBuilder addContent(String text) {
        return this.addContent(text, false, false, null, 0);
    }

    public XMLBuilder addContent(String text, Boolean isWhitespaceContent, Boolean hasSiblings, String delimiter, int level) {
        int preservedNewLines;
        if (!isWhitespaceContent.booleanValue()) {
            if (this.isJoinContentLines()) {
                text = StringUtils.normalizeSpace(text);
            } else if (hasSiblings.booleanValue()) {
                text = text.trim();
            }
            this.xml.append(text);
        } else if (!hasSiblings.booleanValue() && this.isPreserveEmptyContent()) {
            this.xml.append(text);
        } else if (hasSiblings.booleanValue() && (preservedNewLines = this.getPreservedNewlines()) > 0) {
            int newLineCount = StringUtils.getNumberOfNewLines(text, isWhitespaceContent, delimiter, preservedNewLines);
            for (int i = 0; i < newLineCount - 1; ++i) {
                this.xml.append(delimiter);
            }
        }
        return this;
    }

    public XMLBuilder indent(int level) {
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    this.xml.append(" ");
                }
                continue;
            }
            this.xml.append("\t");
        }
        return this;
    }

    public XMLBuilder startPrologOrPI(String tagName) {
        this.xml.append("<?");
        this.xml.append(tagName);
        return this;
    }

    public XMLBuilder addContentPI(String content) {
        this.xml.append(" ");
        this.xml.append(content);
        this.xml.append(" ");
        return this;
    }

    public XMLBuilder endPrologOrPI() {
        this.xml.append("?>");
        return this;
    }

    public String toString() {
        return this.xml.toString();
    }

    public XMLBuilder startCDATA() {
        this.xml.append("<![CDATA[");
        return this;
    }

    public XMLBuilder addContentCDATA(String content) {
        if (this.isJoinCDATALines()) {
            content = StringUtils.normalizeSpace(content);
        }
        this.xml.append(content);
        return this;
    }

    public XMLBuilder endCDATA() {
        this.xml.append("]]>");
        return this;
    }

    public XMLBuilder startComment(DOMComment comment) {
        if (comment.isCommentSameLineEndTag()) {
            this.xml.append(" ");
        }
        this.xml.append("<!--");
        return this;
    }

    public XMLBuilder addContentComment(String content) {
        if (this.isJoinCommentLines()) {
            this.xml.append(" ");
            this.xml.append(StringUtils.normalizeSpace(content));
            this.xml.append(" ");
        } else {
            this.xml.append(content);
        }
        return this;
    }

    public XMLBuilder addDeclTagStart(DTDDeclNode tag) {
        this.xml.append("<!" + tag.getDeclType());
        return this;
    }

    public XMLBuilder startDoctype() {
        this.xml.append("<!DOCTYPE");
        return this;
    }

    public XMLBuilder addParameter(String parameter) {
        this.xml.append(" " + parameter);
        return this;
    }

    public XMLBuilder addUnindentedParameter(String parameter) {
        this.xml.append(parameter);
        return this;
    }

    public XMLBuilder startDoctypeInternalSubset() {
        this.xml.append(" [");
        return this;
    }

    public XMLBuilder endDoctypeInternalSubset() {
        this.xml.append("]");
        return this;
    }

    public XMLBuilder endComment() {
        this.xml.append("-->");
        return this;
    }

    public XMLBuilder endDoctype() {
        this.xml.append(">");
        return this;
    }

    private boolean isJoinCommentLines() {
        return this.formattingOptions != null && this.formattingOptions.isJoinCommentLines();
    }

    private boolean isJoinCDATALines() {
        return this.formattingOptions != null && this.formattingOptions.isJoinCDATALines();
    }

    private boolean isSplitAttributes() {
        return this.formattingOptions != null && this.formattingOptions.isSplitAttributes();
    }

    private boolean isInsertSpaces() {
        return this.formattingOptions != null && this.formattingOptions.isInsertSpaces();
    }

    private int getTabSize() {
        return this.formattingOptions != null ? this.formattingOptions.getTabSize() : 0;
    }

    private boolean isJoinContentLines() {
        return this.formattingOptions != null && this.formattingOptions.isJoinContentLines();
    }

    private boolean isPreserveEmptyContent() {
        return this.formattingOptions != null && this.formattingOptions.isPreserveEmptyContent();
    }

    private int getPreservedNewlines() {
        if (this.formattingOptions != null) {
            return this.formattingOptions.getPreservedNewlines();
        }
        return 2;
    }
}

