/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;

class LSPXMLParserConfiguration
extends XIncludeAwareParserConfiguration {
    private final boolean disableDTDValidation;

    public LSPXMLParserConfiguration(XMLGrammarPool grammarPool, boolean disableDTDValidation, XMLValidationSettings validationSettings) {
        super(null, grammarPool);
        this.disableDTDValidation = disableDTDValidation;
        boolean disallowDocTypeDecl = validationSettings != null ? validationSettings.isDisallowDocTypeDecl() : false;
        super.setFeature("http://apache.org/xml/features/disallow-doctype-decl", disallowDocTypeDecl);
        boolean resolveExternalEntities = validationSettings != null ? validationSettings.isResolveExternalEntities() : false;
        super.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
        super.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
    }

    protected void reset() throws XNIException {
        super.reset();
        if (this.disableDTDValidation) {
            this.disableDTDValidation();
        }
    }

    private void disableDTDValidation() {
        XMLDTDValidator validator = (XMLDTDValidator)super.getProperty("http://apache.org/xml/properties/internal/validator/dtd");
        if (validator != null) {
            XMLComponentManager disableDTDComponent = new XMLComponentManager(){

                public Object getProperty(String propertyId) throws XMLConfigurationException {
                    return LSPXMLParserConfiguration.this.getProperty(propertyId);
                }

                public boolean getFeature(String featureId) throws XMLConfigurationException {
                    if ("http://xml.org/sax/features/validation".equals(featureId)) {
                        return false;
                    }
                    return LSPXMLParserConfiguration.this.getFeature(featureId);
                }
            };
            validator.reset(disableDTDComponent);
        }
    }
}

