/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.internal.ble.util.BTSnoopListener;
import org.eclipse.kura.internal.ble.util.BTSnoopParser;
import org.eclipse.kura.internal.ble.util.BluetoothProcessListener;

public class BluetoothProcess {
    private static final Logger logger = LogManager.getLogger(BluetoothProcess.class);
    private static final ExecutorService streamGobblers = Executors.newCachedThreadPool();
    private Future<?> futureInputGobbler;
    private Future<?> futureErrorGobbler;
    private BufferedWriter bufferedWriter;
    private final PipedInputStream readOutputStream = new PipedInputStream();
    private final PipedInputStream readErrorStream = new PipedInputStream();
    private final PipedOutputStream outputStream = new PipedOutputStream();
    private final PipedOutputStream errorStream = new PipedOutputStream();
    private BTSnoopParser parser;
    private boolean btSnoopReady;
    private final CommandExecutorService executorService;

    public BluetoothProcess(CommandExecutorService executorService) {
        this.executorService = executorService;
        try {
            this.outputStream.connect(this.readOutputStream);
            this.errorStream.connect(this.readErrorStream);
        }
        catch (IOException e) {
            logger.error("Failed to connect streams", (Throwable)e);
        }
    }

    public BufferedWriter getWriter() {
        return this.bufferedWriter;
    }

    void exec(String[] cmdArray, BluetoothProcessListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        }
        Consumer<CommandStatus> callback = status -> logger.debug("Command ended with exit value {}", (Object)status.getExitStatus().getExitCode());
        Command command = new Command(cmdArray);
        command.setOutputStream((OutputStream)this.outputStream);
        command.setErrorStream((OutputStream)this.errorStream);
        this.executorService.execute(command, callback);
        this.futureInputGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess Input Stream Gobbler");
            try {
                this.readInputStreamFully(this.readOutputStream, listener);
            }
            catch (IOException | KuraException e) {
                logger.error("Process input stream failed", e);
            }
        });
        this.futureErrorGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess ErrorStream Gobbler");
            try {
                this.readErrorStreamFully(this.readErrorStream, listener);
            }
            catch (IOException | KuraException e) {
                logger.error("Process error stream failed", e);
            }
        });
    }

    void execSnoop(String[] cmdArray, BTSnoopListener listener) {
        this.btSnoopReady = true;
        if (this.parser == null) {
            this.parser = new BTSnoopParser();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        }
        Consumer<CommandStatus> callback = status -> logger.debug("Command ended with exit value {}", (Object)status.getExitStatus().getExitCode());
        StringBuilder commandLine = new StringBuilder();
        commandLine.append("{ exec");
        Arrays.asList(cmdArray).stream().forEach(s -> {
            commandLine.append(" ");
            commandLine.append((String)s);
        });
        commandLine.append(" >/dev/null;");
        commandLine.append(" }");
        commandLine.append(" 3>&1");
        Command command = new Command(commandLine.toString().split("\\s+"));
        command.setOutputStream((OutputStream)this.outputStream);
        command.setErrorStream((OutputStream)this.errorStream);
        command.setExecuteInAShell(true);
        this.executorService.execute(command, callback);
        this.futureInputGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop Gobbler");
            try {
                this.readBTSnoopStreamFully(this.readOutputStream, listener);
            }
            catch (IOException e) {
                logger.debug("Process snoop input stream failed", (Throwable)e);
            }
        });
        this.futureErrorGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop ErrorStream Gobbler");
            try {
                this.readBTErrorStreamFully(this.readErrorStream, listener);
            }
            catch (IOException e) {
                logger.debug("Process snoop error stream failed", (Throwable)e);
            }
        });
    }

    public void destroy() {
        this.closeStreams();
    }

    public void destroyBTSnoop() {
        this.btSnoopReady = false;
        this.closeStreams();
    }

    private String readStream(InputStream is) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            stringBuilder.append(String.valueOf(line) + "\n");
        }
        logger.debug("End of stream!");
        return stringBuilder.toString();
    }

    private void readInputStreamFully(InputStream is, BluetoothProcessListener listener) throws IOException, KuraException {
        listener.processInputStream(this.readStream(is));
    }

    private void readBTSnoopStreamFully(InputStream is, BTSnoopListener listener) throws IOException {
        this.parser.setInputStream(is);
        while (this.btSnoopReady) {
            byte[] packet;
            if (is == null || (packet = this.parser.readRecord()).length <= 0) continue;
            listener.processBTSnoopRecord(packet);
        }
        logger.debug("End of btsnoop stream!");
    }

    private void readErrorStreamFully(InputStream is, BluetoothProcessListener listener) throws IOException, KuraException {
        listener.processErrorStream(this.readStream(is));
    }

    private void readBTErrorStreamFully(InputStream is, BTSnoopListener listener) throws IOException {
        listener.processBTSnoopErrorStream(this.readStream(is));
    }

    private void closeStreams() {
        logger.info("Closing streams and killing...");
        if (this.futureInputGobbler != null) {
            this.futureInputGobbler.cancel(true);
        }
        if (this.futureErrorGobbler != null) {
            this.futureErrorGobbler.cancel(true);
        }
        this.closeQuietly(this.outputStream);
        this.closeQuietly(this.errorStream);
        this.closeQuietly(this.readOutputStream);
        this.closeQuietly(this.readErrorStream);
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process input stream", (Throwable)e);
            }
        }
    }

    private void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process output stream", (Throwable)e);
            }
        }
    }
}

