/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.types.DBusStructType;
import org.freedesktop.dbus.types.Variant;

public class StructHelper {
    private StructHelper() {
    }

    public static <T extends Struct> T createStructFromVariant(Variant<?> _variant, Class<T> _structClass) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (_variant == null || _structClass == null) {
            return null;
        }
        if (_variant.getType() instanceof DBusStructType && _variant.getValue() instanceof Object[]) {
            Class[] argTypes = (Class[])Arrays.stream((Object[])_variant.getValue()).map(a -> a.getClass()).toArray((IntFunction<A[]>)new IntFunction<Class<?>[]>(){

                @Override
                public Class<?>[] apply(int size) {
                    return new Class[size];
                }
            });
            return StructHelper.createStruct(argTypes, _variant.getValue(), _structClass);
        }
        return null;
    }

    public static <T extends Struct> T createStruct(Class<?>[] _constructorArgs, Object _values, Class<T> _classToConstruct) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (_constructorArgs == null || _classToConstruct == null || _values == null) {
            return null;
        }
        try {
            Constructor<T> declaredConstructor = _classToConstruct.getDeclaredConstructor(_constructorArgs);
            declaredConstructor.setAccessible(true);
            if (_values instanceof Object[]) {
                return (T)((Struct)declaredConstructor.newInstance((Object[])_values));
            }
            return (T)((Struct)declaredConstructor.newInstance(_values));
        }
        catch (NoSuchMethodException | SecurityException _ex) {
            for (int i = 0; i < _constructorArgs.length; ++i) {
                Class<?> class1 = _constructorArgs[i];
                if (!ArrayFrob.getWrapperToPrimitiveTypes().containsKey(class1)) continue;
                _constructorArgs[i] = ArrayFrob.getWrapperToPrimitiveTypes().get(class1);
                return StructHelper.createStruct(_constructorArgs, _values, _classToConstruct);
            }
            throw new NoSuchMethodException("Cannot find suitable constructor for arguments " + Arrays.toString(_constructorArgs) + " in class " + _classToConstruct + ".");
        }
    }
}

