/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.rest.configuration.api.Failure;
import org.eclipse.kura.rest.configuration.api.SubtaskFailure;
import org.eclipse.kura.rest.configuration.api.SubtaskFailureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(FailureHandler.class);
    private final List<SubtaskFailure> failures = new ArrayList<SubtaskFailure>();

    public void runFallibleSubtask(String id, FallibleTask fallibleTask) {
        try {
            fallibleTask.run();
        }
        catch (Exception e) {
            this.processFailure(id, e);
        }
    }

    public void processFailure(String id, Exception e) {
        logger.warn("task failed {}", (Object)id, (Object)e);
        this.failures.add(new SubtaskFailure(id, e.getMessage() != null ? e.getMessage() : "An internal error occurred"));
    }

    public void checkStatus() {
        if (!this.failures.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)new SubtaskFailureList(this.failures)).build());
        }
    }

    public static WebApplicationException parameterRequired(String parameter) {
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new Failure("parameter \"" + parameter + "\" is required")).build();
        return new WebApplicationException(response);
    }

    public static void requireParameter(Object value, String name) {
        if (value == null) {
            throw FailureHandler.parameterRequired(name);
        }
    }

    @FunctionalInterface
    public static interface FallibleTask {
        public void run() throws KuraException;
    }
}

