/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.JmxNotificationBroadcasterAware;
import org.apache.camel.management.mbean.ManagedEventNotifierMBean;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;

public class ManagedEventNotifier
extends NotificationBroadcasterSupport
implements ManagedEventNotifierMBean {
    private final CamelContext context;
    private final EventNotifier eventNotifier;

    public ManagedEventNotifier(CamelContext context, EventNotifier eventNotifier) {
        this.context = context;
        this.eventNotifier = eventNotifier;
        if (eventNotifier instanceof JmxNotificationBroadcasterAware) {
            ((JmxNotificationBroadcasterAware)((Object)eventNotifier)).setNotificationBroadcaster(this);
        }
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    public EventNotifier getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public boolean isIgnoreCamelContextEvents() {
        return this.getEventNotifier().isIgnoreCamelContextEvents();
    }

    @Override
    public void setIgnoreCamelContextEvents(boolean ignoreCamelContextEvents) {
        this.getEventNotifier().setIgnoreCamelContextEvents(ignoreCamelContextEvents);
    }

    @Override
    public boolean isIgnoreRouteEvents() {
        return this.getEventNotifier().isIgnoreRouteEvents();
    }

    @Override
    public void setIgnoreRouteEvents(boolean ignoreRouteEvents) {
        this.getEventNotifier().setIgnoreRouteEvents(ignoreRouteEvents);
    }

    @Override
    public boolean isIgnoreServiceEvents() {
        return this.getEventNotifier().isIgnoreServiceEvents();
    }

    @Override
    public void setIgnoreServiceEvents(boolean ignoreServiceEvents) {
        this.getEventNotifier().setIgnoreServiceEvents(ignoreServiceEvents);
    }

    @Override
    public boolean isIgnoreExchangeEvents() {
        return this.getEventNotifier().isIgnoreExchangeEvents();
    }

    @Override
    public void setIgnoreExchangeEvents(boolean ignoreExchangeEvents) {
        this.getEventNotifier().setIgnoreExchangeEvents(ignoreExchangeEvents);
    }

    @Override
    public boolean isIgnoreExchangeCreatedEvent() {
        return this.getEventNotifier().isIgnoreExchangeCreatedEvent();
    }

    @Override
    public void setIgnoreExchangeCreatedEvent(boolean ignoreExchangeCreatedEvent) {
        this.getEventNotifier().setIgnoreExchangeCreatedEvent(ignoreExchangeCreatedEvent);
    }

    @Override
    public boolean isIgnoreExchangeCompletedEvent() {
        return this.getEventNotifier().isIgnoreExchangeCompletedEvent();
    }

    @Override
    public void setIgnoreExchangeCompletedEvent(boolean ignoreExchangeCompletedEvent) {
        this.getEventNotifier().setIgnoreExchangeCompletedEvent(ignoreExchangeCompletedEvent);
    }

    @Override
    public boolean isIgnoreExchangeFailedEvents() {
        return this.getEventNotifier().isIgnoreExchangeFailedEvents();
    }

    @Override
    public void setIgnoreExchangeFailedEvents(boolean ignoreExchangeFailedEvents) {
        this.getEventNotifier().setIgnoreExchangeFailedEvents(ignoreExchangeFailedEvents);
    }

    @Override
    public boolean isIgnoreExchangeRedeliveryEvents() {
        return this.getEventNotifier().isIgnoreExchangeRedeliveryEvents();
    }

    @Override
    public void setIgnoreExchangeRedeliveryEvents(boolean ignoreExchangeRedeliveryEvents) {
        this.getEventNotifier().setIgnoreExchangeRedeliveryEvents(ignoreExchangeRedeliveryEvents);
    }

    @Override
    public boolean isIgnoreExchangeSentEvents() {
        return this.getEventNotifier().isIgnoreExchangeSentEvents();
    }

    @Override
    public void setIgnoreExchangeSentEvents(boolean ignoreExchangeSentEvents) {
        this.getEventNotifier().setIgnoreExchangeSentEvents(ignoreExchangeSentEvents);
    }

    @Override
    public boolean isIgnoreExchangeSendingEvents() {
        return this.getEventNotifier().isIgnoreExchangeSendingEvents();
    }

    @Override
    public void setIgnoreExchangeSendingEvents(boolean ignoreExchangeSendingEvents) {
        this.getEventNotifier().setIgnoreExchangeSendingEvents(ignoreExchangeSendingEvents);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] names = new String[]{"CamelContextStartedEvent", "CamelContextStartingEvent", "CamelContextStartupFailureEvent", "CamelContextStopFailureEvent", "CamelContextStoppedEvent", "CamelContextStoppingEvent", "CamelContextSuspendingEvent", "CamelContextSuspendedEvent", "CamelContextResumingEvent", "CamelContextResumedEvent", "CamelContextResumeFailureEvent", "ExchangeCompletedEvent", "ExchangeCreatedEvent", "ExchangeFailedEvent", "ExchangeFailureHandledEvent", "ExchangeRedeliveryEvents", "ExchangeSendingEvent", "ExchangeSentEvent", "RouteStartedEvent", "RouteStoppedEvent", "ServiceStartupFailureEvent", "ServiceStopFailureEvent"};
        ArrayList<MBeanNotificationInfo> infos = new ArrayList<MBeanNotificationInfo>();
        for (String name : names) {
            MBeanNotificationInfo info = new MBeanNotificationInfo(new String[]{"org.apache.camel.management.event"}, "org.apache.camel.management.event." + name, "The event " + name + " occurred");
            infos.add(info);
        }
        return infos.toArray(new MBeanNotificationInfo[infos.size()]);
    }
}

