/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizeDatasetTests {
    @Parameterized.Parameter
    public Class<? extends Dataset> classType;
    private static final double ABSERRD = 1.0E-8;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(FloatDataset.class, DoubleDataset.class, ByteDataset.class, ShortDataset.class, IntegerDataset.class, LongDataset.class);
    }

    @Test
    public void testGetElementBooleanAbs() {
        Class<? extends Dataset> class1 = this.classType;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        double[] value = new double[]{4.2, -2.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray2[n2];
            boolean actualResult = input.getElementBooleanAbs(val);
            boolean result = value[val] != 0.0;
            Assert.assertEquals((Object)result, (Object)actualResult);
            ++n2;
        }
    }

    @Test
    public void testGetElementDoubleAbs() {
        Class<? extends Dataset> class1 = this.classType;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        double[] value = new double[]{4.2, -2.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray2[n2];
            double actualResult = input.getElementDoubleAbs(val);
            double result = value[val];
            Assert.assertEquals((double)result, (double)actualResult, (double)0.9);
            ++n2;
        }
    }

    @Test
    public void testGetElementLongAbs() {
        Class<? extends Dataset> class1 = this.classType;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        double[] value = new double[]{4.2, -2.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray2[n2];
            long actualResult = input.getElementLongAbs(val);
            long result = (long)value[val];
            Assert.assertEquals((long)result, (long)actualResult);
            ++n2;
        }
    }

    @Test
    public void testEquals() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -2.9, 6.1, 0.0};
        double[] value2 = new double[]{4.2, -7.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset checkerTrue = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset checkerFalse = DatasetFactory.createFromObject(class1, (Object)value2);
        boolean checkInput1 = input.equals(checkerTrue);
        boolean checkInput2 = input.equals(checkerFalse);
        Assert.assertEquals((Object)checkInput1, (Object)true);
        Assert.assertEquals((Object)checkInput2, (Object)false);
    }

    @Test
    public void testCreateRange() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        Dataset input = DatasetFactory.createRange(class1, (double)5.0);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)value);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testSortWithNull() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        double[] sortedObj = new double[]{-7.9, 0.0, 4.2, 6.1};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)sortedObj);
        input.sort(null);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testSort() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        double[] sortedObj = new double[]{-7.9, 4.2, 0.0, 6.1};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value).reshape(new int[]{2, 2});
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)sortedObj).reshape(new int[]{2, 2});
        input.sort(Integer.valueOf(1));
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testResize() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        double[][] resizedObj = new double[][]{{4.2, -7.9}, {6.1, 0.0}};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)resizedObj);
        input.resize(new int[]{2, 2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testGetUniqueItems() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0, 0.0};
        double[] sortedObj = new double[]{-7.9, 0.0, 4.2, 6.1};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)sortedObj);
        input = input.getUniqueItems();
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testGetSlice() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{52.0, 74.0, 0.0, -5.0, 71.0, 0.0, 3.0, -9.0};
        double[] expectedObj = new double[]{0.0, -5.0, 71.0, 0.0, 3.0};
        Dataset dataset = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)expectedObj);
        Dataset actual = dataset.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testFillDataset() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        IndexIterator iter = input.getIterator();
        Dataset expected = DatasetFactory.zeros(class1, (int[])new int[]{4});
        input.fillDataset(expected, iter);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testFill() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.ones(class1, (int[])new int[]{4});
        input.fill((Object)1);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testMaxPos() throws Exception {
        Class<? extends Dataset> class1 = this.classType;
        double[] da = new double[]{1.2, 2.3, 13.0, 4.6, 2.8, 2.3, 13.0};
        Dataset dataset = DatasetFactory.createFromObject(class1, (Object)da);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])dataset.maxPos(new boolean[0]));
    }

    @Test
    public void testMinPos() throws Exception {
        Class<? extends Dataset> class1 = this.classType;
        double[] da = new double[]{1.2, 2.3, 13.0, 4.6, 2.8, 2.3, 13.0};
        Dataset dataset = DatasetFactory.createFromObject(class1, (Object)da);
        Assert.assertArrayEquals((int[])new int[1], (int[])dataset.minPos(new boolean[0]));
    }

    @Test
    public void testIAdd() {
        Class<? extends Dataset> class1 = this.classType;
        byte[] byArray = new byte[4];
        byArray[0] = 4;
        byArray[1] = -7;
        byArray[2] = 6;
        byte[] value = byArray;
        byte[] valueToAdd = new byte[]{5, 6, 7, 4};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] + valueToAdd[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.iadd((Object)valueToAdd);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testISubstract() {
        Class<? extends Dataset> class1 = this.classType;
        byte[] byArray = new byte[4];
        byArray[0] = 4;
        byArray[1] = -7;
        byArray[2] = 6;
        byte[] value = byArray;
        byte[] valueToSubstract = new byte[]{5, 6, 7, 4};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] - valueToSubstract[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.isubtract((Object)valueToSubstract);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testIReminder() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        double[] valueToSubstract = new double[]{5.9, 6.0, 7.3, 4.6};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] % valueToSubstract[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.iremainder((Object)valueToSubstract);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testIdivide() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.2, -7.9, 6.1, 0.0};
        double[] valueToAdd = new double[]{5.4, 6.0, 7.3, 4.6};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] / valueToAdd[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.idivide((Object)valueToAdd);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testIpowerWithSingleNumber() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.0, -7.0, 6.0, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = Math.pow(value[index], 2.0);
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.ipower((Object)2);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testIpower() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{4.0, -7.0, 6.0, 0.0};
        double[] valueToAdd = new double[]{5.4, 6.0, 7.3, 4.6};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        double[] result = new double[4];
        int index = 0;
        while (index < 4) {
            result[index] = Math.pow(value[index], valueToAdd[index]);
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)result);
        input.ipower((Object)valueToAdd);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testSetByBoolean() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] newObj = new double[]{5.0, 7.0};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] bool = blArray;
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset newInput = DatasetFactory.createFromObject(class1, (Object)newObj);
        Dataset boolInput = DatasetFactory.createFromObject(BooleanDataset.class, (Object)bool);
        Dataset output = input.setByBoolean((Object)newInput, boolInput);
        double[] expectedObj = new double[]{5.0, 2.0, 7.0, 4.0};
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)expectedObj);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)output, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testSetby1DIndex() {
        Class<? extends Dataset> class1 = this.classType;
        double[] valuesIn = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] valueExpected = new double[]{13.0, 2.0, 96.0, 4.0};
        double[] valueOut = new double[]{13.0, 96.0};
        Dataset out = DatasetFactory.createFromObject(class1, (Object)valueOut);
        Dataset in = DatasetFactory.createFromObject(class1, (Object)valuesIn);
        int[] nArray = new int[2];
        nArray[1] = 2;
        Dataset index = DatasetFactory.createFromObject((Object)nArray);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)valueExpected);
        Dataset actual = in.setBy1DIndex((Object)out, index);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testSetSlice() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] valueExpected = new double[]{1.0, 2.0, 0.0, 0.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)valueExpected);
        DoubleDataset tdata = DatasetFactory.zeros((int[])new int[]{2});
        SliceIterator siter = (SliceIterator)input.getSliceIterator(new int[]{2}, new int[]{4}, null);
        input.setSlice((Object)tdata, (IndexIterator)siter);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testSetByIndexes() {
        Class<? extends Dataset> class1 = this.classType;
        double[][] valuesIn = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}};
        double[] valueOut = new double[]{13.0, 96.0};
        double[][] valueExpected = new double[][]{{1.0, 13.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 96.0}};
        Dataset expected = DatasetFactory.createFromObject(class1, (Object)valueExpected);
        Dataset in = DatasetFactory.createFromObject(class1, (Object)valuesIn);
        Dataset out = DatasetFactory.createFromObject(class1, (Object)valueOut);
        int[] nArray = new int[2];
        nArray[1] = 1;
        Dataset index1 = DatasetFactory.createFromObject((Object)nArray);
        Dataset index2 = DatasetFactory.createFromObject((Object)new int[]{1, 3});
        Dataset actual = in.setByIndexes((Object)out, new Object[]{index1, index2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testResidual() {
        Class<? extends Dataset> class1 = this.classType;
        double[] value = new double[]{0.0, 2.0, 3.0, 4.0};
        double[] value2 = new double[]{1.0, 3.0, 4.0, 5.0};
        double[] valueW = new double[]{1.0, 0.0, 1.0, 1.0};
        Dataset in = DatasetFactory.createFromObject(class1, (Object)value);
        Dataset in2 = DatasetFactory.createFromObject(class1, (Object)value2);
        Dataset w = DatasetFactory.createFromObject(class1, (Object)valueW);
        double sumExpected = 3.0;
        double sum = in.residual((Object)in2, w, true);
        Assert.assertEquals((double)sumExpected, (double)sum, (double)1.0E-8);
        sum = in.residual((Object)in2, null, true);
        sumExpected = 4.0;
        Assert.assertEquals((double)sumExpected, (double)sum, (double)1.0E-8);
    }
}

