/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.LazyMaths;
import org.eclipse.january.dataset.Maths;
import org.junit.Before;
import org.junit.Test;

public class LazyMathsTest {
    private ILazyDataset a2x2L;
    private ILazyDataset b4x4x4x4L;
    private ILazyDataset c4x5x6x7L;
    private Dataset a2x2D;
    private Dataset b4x4x4x4D;
    private Dataset c4x5x6x7D;

    @Before
    public void init() throws Exception {
        this.a2x2D = DatasetFactory.createRange((double)4.0).reshape(new int[]{2, 2});
        this.a2x2L = LazyDataset.createLazyDataset((Dataset)this.a2x2D);
        this.b4x4x4x4D = DatasetFactory.createRange((double)256.0).reshape(new int[]{4, 4, 4, 4});
        this.b4x4x4x4L = LazyDataset.createLazyDataset((Dataset)this.b4x4x4x4D);
        this.c4x5x6x7D = DatasetFactory.createRange((double)840.0).reshape(new int[]{4, 5, 6, 7});
        this.c4x5x6x7L = LazyDataset.createLazyDataset((Dataset)this.c4x5x6x7D);
    }

    @Test
    public void testMaxNoAxis() throws Exception {
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)this.a2x2D.max(new boolean[0])), (Dataset)LazyMaths.max((ILazyDataset)this.a2x2L, (int[])new int[0]));
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)this.b4x4x4x4D.max(new boolean[0])), (Dataset)LazyMaths.max((ILazyDataset)this.b4x4x4x4L, (int[])new int[0]));
    }

    @Test
    public void testMinNoAxis() throws Exception {
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)this.a2x2D.min(new boolean[0])), (Dataset)LazyMaths.min((ILazyDataset)this.a2x2L, (int[])new int[0]));
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)this.b4x4x4x4D.min(new boolean[0])), (Dataset)LazyMaths.min((ILazyDataset)this.b4x4x4x4L, (int[])new int[0]));
    }

    @Test
    public void testMaxSingleAxis() throws Exception {
        TestUtils.assertDatasetEquals((Dataset)this.a2x2D.max(0, new boolean[0]), (Dataset)LazyMaths.max((ILazyDataset)this.a2x2L, (int[])new int[]{0}));
        TestUtils.assertDatasetEquals((Dataset)this.a2x2D.max(1, new boolean[0]), (Dataset)LazyMaths.max((ILazyDataset)this.a2x2L, (int[])new int[]{1}));
        int i = 0;
        while (i < 4) {
            Dataset expected = this.b4x4x4x4D.max(i, new boolean[0]);
            Dataset actual = LazyMaths.max((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{i++});
            TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        }
    }

    @Test
    public void testMinSingleAxis() throws Exception {
        TestUtils.assertDatasetEquals((Dataset)this.a2x2D.min(0, new boolean[0]), (Dataset)LazyMaths.min((ILazyDataset)this.a2x2L, (int[])new int[]{0}));
        TestUtils.assertDatasetEquals((Dataset)this.a2x2D.min(1, new boolean[0]), (Dataset)LazyMaths.min((ILazyDataset)this.a2x2L, (int[])new int[]{1}));
        int i = 0;
        while (i < 4) {
            Dataset expected = this.b4x4x4x4D.min(i, new boolean[0]);
            Dataset actual = LazyMaths.min((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{i++});
            TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        }
    }

    @Test
    public void testMaxMultipleAxes() throws Exception {
        Dataset expected = DatasetFactory.createFromObject((Object)new double[]{15.0, 31.0, 47.0, 63.0, 79.0, 95.0, 111.0, 127.0, 143.0, 159.0, 175.0, 191.0, 207.0, 223.0, 239.0, 255.0}, (int[])new int[]{4, 4});
        Dataset actual = LazyMaths.max((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        actual = LazyMaths.max((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{3, 2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        expected = DatasetFactory.createFromObject((Object)new double[]{41.0, 83.0, 125.0, 167.0, 209.0, 251.0, 293.0, 335.0, 377.0, 419.0, 461.0, 503.0, 545.0, 587.0, 629.0, 671.0, 713.0, 755.0, 797.0, 839.0}, (int[])new int[]{4, 5});
        actual = LazyMaths.max((ILazyDataset)this.c4x5x6x7L, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testMinMultipleAxes() throws Exception {
        Dataset expected = DatasetFactory.createFromObject((Object)new double[]{15.0, 31.0, 47.0, 63.0, 79.0, 95.0, 111.0, 127.0, 143.0, 159.0, 175.0, 191.0, 207.0, 223.0, 239.0, 255.0}, (int[])new int[]{4, 4}).isubtract((Object)15);
        Dataset actual = LazyMaths.min((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        actual = LazyMaths.min((ILazyDataset)this.b4x4x4x4L, (int[])new int[]{3, 2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        expected = DatasetFactory.createFromObject((Object)new double[]{41.0, 83.0, 125.0, 167.0, 209.0, 251.0, 293.0, 335.0, 377.0, 419.0, 461.0, 503.0, 545.0, 587.0, 629.0, 671.0, 713.0, 755.0, 797.0, 839.0}, (int[])new int[]{4, 5}).isubtract((Object)41);
        actual = LazyMaths.min((ILazyDataset)this.c4x5x6x7L, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testMaxMultipleAxesNonLazy() throws Exception {
        Dataset expected = DatasetFactory.createFromObject((Object)new double[]{15.0, 31.0, 47.0, 63.0, 79.0, 95.0, 111.0, 127.0, 143.0, 159.0, 175.0, 191.0, 207.0, 223.0, 239.0, 255.0}, (int[])new int[]{4, 4});
        Dataset actual = LazyMaths.max((ILazyDataset)this.b4x4x4x4D, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        actual = LazyMaths.max((ILazyDataset)this.b4x4x4x4D, (int[])new int[]{3, 2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        expected = DatasetFactory.createFromObject((Object)new double[]{41.0, 83.0, 125.0, 167.0, 209.0, 251.0, 293.0, 335.0, 377.0, 419.0, 461.0, 503.0, 545.0, 587.0, 629.0, 671.0, 713.0, 755.0, 797.0, 839.0}, (int[])new int[]{4, 5});
        actual = LazyMaths.max((ILazyDataset)this.c4x5x6x7D, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testMinMultipleAxesNonLazy() throws Exception {
        Dataset expected = DatasetFactory.createFromObject((Object)new double[]{15.0, 31.0, 47.0, 63.0, 79.0, 95.0, 111.0, 127.0, 143.0, 159.0, 175.0, 191.0, 207.0, 223.0, 239.0, 255.0}, (int[])new int[]{4, 4}).isubtract((Object)15);
        Dataset actual = LazyMaths.min((ILazyDataset)this.b4x4x4x4D, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        actual = LazyMaths.min((ILazyDataset)this.b4x4x4x4D, (int[])new int[]{3, 2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
        expected = DatasetFactory.createFromObject((Object)new double[]{41.0, 83.0, 125.0, 167.0, 209.0, 251.0, 293.0, 335.0, 377.0, 419.0, 461.0, 503.0, 545.0, 587.0, 629.0, 671.0, 713.0, 755.0, 797.0, 839.0}, (int[])new int[]{4, 5}).isubtract((Object)41);
        actual = LazyMaths.min((ILazyDataset)this.c4x5x6x7D, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testSum() throws Exception {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)3), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testSumIgnoreAxes() throws Exception {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[1]), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1, 2, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 2, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{1, 0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]).sum(2, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 3, 2}), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testProduct() throws Exception {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        a.iadd((Object)1.0);
        a.idivide((Object)100.0);
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(2, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(2, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(3, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)3), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testMeanIgnore() throws Exception {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{1}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.mean(2, new boolean[0]).mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(2, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{1, 2}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).mean(2, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).mean(2, new boolean[0]).mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).squeeze(), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]).mean(0, new boolean[0]).squeeze(), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{2, 3}), (double)1.0E-9, (double)1.0E-15);
        DoubleDataset er = DatasetFactory.createRange((double)100.0);
        a.setShape(new int[]{10, 10});
        er.setShape(new int[]{10, 10});
        a.setErrorBuffer((Serializable)er);
        Dataset e = Maths.sqrt((Object)er.sum(1, new boolean[0])).idivide((Object)10);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}).getErrors(), (double)1.0E-9, (double)1.0E-15);
    }
}

