/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;

public class SliceableTestMetadata
implements MetadataType {
    private static final long serialVersionUID = 1L;
    @Reshapeable
    @Sliceable
    private ILazyDataset ds;
    @Reshapeable
    @Sliceable
    private DoubleDataset[] dds;
    @Reshapeable
    @Sliceable
    private List<ShortDataset> lds;
    @Reshapeable
    @Sliceable
    private Map<String, BooleanDataset> mds;
    @Reshapeable
    @Sliceable
    private List<DoubleDataset[]> l2deep;

    public SliceableTestMetadata(ILazyDataset ld, DoubleDataset[] array, List<ShortDataset> list, Map<String, BooleanDataset> map, List<DoubleDataset[]> l2) {
        this.ds = ld;
        this.dds = array;
        this.lds = list;
        this.mds = map;
        this.l2deep = l2;
    }

    public SliceableTestMetadata(SliceableTestMetadata stm) {
        this.ds = stm.ds == null ? null : stm.ds.getSliceView(new Slice[0]);
        if (stm.dds == null) {
            this.dds = null;
        } else {
            this.dds = new DoubleDataset[stm.dds.length];
            int i = 0;
            while (i < this.dds.length) {
                this.dds[i] = stm.dds[i].getView(true);
                ++i;
            }
        }
        if (stm.lds == null) {
            this.lds = null;
        } else {
            this.lds = new ArrayList<ShortDataset>();
            for (ShortDataset d : stm.lds) {
                this.lds.add(d.getView(true));
            }
        }
        if (stm.mds == null) {
            this.mds = null;
        } else {
            this.mds = new HashMap<String, BooleanDataset>();
            for (String s : stm.mds.keySet()) {
                this.mds.put(s, stm.mds.get(s).getView(true));
            }
        }
        if (stm.l2deep == null) {
            this.l2deep = null;
        } else {
            this.l2deep = new ArrayList<DoubleDataset[]>();
            for (DoubleDataset[] da : stm.l2deep) {
                DoubleDataset[] ta = new DoubleDataset[da.length];
                int i = 0;
                while (i < ta.length) {
                    ta[i] = da[i].getView(true);
                    ++i;
                }
                this.l2deep.add(ta);
            }
        }
    }

    public MetadataType clone() {
        return new SliceableTestMetadata(this);
    }

    public ILazyDataset getLazyDataset() {
        return this.ds;
    }

    public DoubleDataset[] getArray() {
        return this.dds;
    }

    public List<ShortDataset> getList() {
        return this.lds;
    }

    public Map<String, BooleanDataset> getMap() {
        return this.mds;
    }

    public List<DoubleDataset[]> getListOfArrays() {
        return this.l2deep;
    }
}

