/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.negdep.onopen.srv.toomanyargs;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.negdep.EchoServerEndpoint;
import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;
import com.sun.ts.tests.websocket.negdep.StringHolder;
import com.sun.ts.tests.websocket.negdep.onopen.srv.toomanyargs.OnOpenServerEndpoint;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends NegativeDeploymentClient {
    private static final long serialVersionUID = 111L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_negdep_onopen_srv_toomanyarguments_web.war");
        archive.addClasses(new Class[]{OnOpenServerEndpoint.class});
        archive.addClasses(new Class[]{EchoServerEndpoint.class, StringHolder.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_negdep_onopen_srv_toomanyarguments_web");
    }

    @Test
    public void tooManyArgumentsOnOpenUndeployOtherEndpointTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("echo"));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if ("anything".equals(response)) {
            this.throwValidEndpointMustBeRemoved();
        }
    }

    @Test
    public void tooManyArgumentsOnOpenTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("invalid"));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if (response != null && response.contains("anything")) {
            this.throwValidEndpointMustBeRemoved();
        }
    }
}

