/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithBinaryDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithBinaryEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithBinaryStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithIOBinaryStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithIOBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithIOTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithIOTextStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithTextEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCClientEndpointWithTextStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithBinaryEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithIOBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithIOTextStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithTextEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated.WSCReturningClientEndpointWithTextStreamEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -8094860820359975543L;
    protected static final String ECHO = "Echo message";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ee_java_websocket_throwingcoder_annotated_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder"});
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class, WSCClientEndpointWithBinaryDecoder.class, WSCClientEndpointWithBinaryEncoder.class, WSCClientEndpointWithBinaryStreamDecoder.class, WSCClientEndpointWithBinaryStreamEncoder.class, WSCClientEndpointWithIOBinaryStreamDecoder.class, WSCClientEndpointWithIOBinaryStreamEncoder.class, WSCClientEndpointWithIOTextStreamDecoder.class, WSCClientEndpointWithIOTextStreamEncoder.class, WSCClientEndpointWithTextDecoder.class, WSCClientEndpointWithTextEncoder.class, WSCClientEndpointWithTextStreamDecoder.class, WSCClientEndpointWithTextStreamEncoder.class, WSCClientEndpointWithTextStreamDecoder.class, WSCClientEndpointWithTextStreamEncoder.class, WSCReturningClientEndpointWithBinaryEncoder.class, WSCReturningClientEndpointWithBinaryStreamEncoder.class, WSCReturningClientEndpointWithIOBinaryStreamEncoder.class, WSCReturningClientEndpointWithIOTextStreamEncoder.class, WSCReturningClientEndpointWithTextEncoder.class, WSCReturningClientEndpointWithTextStreamEncoder.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated"});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{StringBeanClientEndpoint.class}), new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ee_java_websocket_throwingcoder_annotated_web");
        this.logExceptionOnInvocation(false);
    }

    @Test
    public void binaryDecoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("binarydecoder", (Object)ByteBuffer.wrap(ECHO.getBytes()), "TCK coder exception for test");
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void binaryDecoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithBinaryDecoder endpoint = new WSCClientEndpointWithBinaryDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simplebin", ECHO);
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamDecoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("binarystreamdecoder", (Object)ByteBuffer.wrap(ECHO.getBytes()), "TCK coder exception for test");
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamDecoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithBinaryStreamDecoder endpoint = new WSCClientEndpointWithBinaryStreamDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simplebin", ECHO);
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void textDecoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("textdecoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void textDecoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithTextDecoder endpoint = new WSCClientEndpointWithTextDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void textStreamDecoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("textstreamdecoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void textStreamDecoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithTextStreamDecoder endpoint = new WSCClientEndpointWithTextStreamDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The DecoderException has been propagated to @OnError");
    }

    @Test
    public void binaryEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("binaryencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void binaryEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithBinaryEncoder endpoint = new WSCClientEndpointWithBinaryEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("binarystreamencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithBinaryStreamEncoder endpoint = new WSCClientEndpointWithBinaryStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void textEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("textencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void textEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithTextEncoder endpoint = new WSCClientEndpointWithTextEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void textStreamEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("textstreamencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void textStreamEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithTextStreamEncoder endpoint = new WSCClientEndpointWithTextStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("returningbinaryencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithBinaryEncoder endpoint = new WSCReturningClientEndpointWithBinaryEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryStreamEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("returningbinarystreamencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryStreamEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithBinaryStreamEncoder endpoint = new WSCReturningClientEndpointWithBinaryStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningTextEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("returningtextencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningTextEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithTextEncoder endpoint = new WSCReturningClientEndpointWithTextEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningTextStreamEncoderThrowAndCatchOnServerTest() throws Exception {
        this.invoke("returningtextstreamencoder", (Object)ECHO, "TCK coder exception for test");
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void returningTextStreamEncoderThrowAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithTextStreamEncoder endpoint = new WSCReturningClientEndpointWithTextStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The EncoderException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamDecoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("iobinarystreamdecoder", (Object)ByteBuffer.wrap(ECHO.getBytes()), "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamDecoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithIOBinaryStreamDecoder endpoint = new WSCClientEndpointWithIOBinaryStreamDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simplebin", ECHO);
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void textStreamDecoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("iotextstreamdecoder", (Object)ECHO, "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void textStreamDecoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithIOTextStreamDecoder endpoint = new WSCClientEndpointWithIOTextStreamDecoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamEncoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("iobinarystreamencoder", (Object)ECHO, "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void binaryStreamEncoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithIOBinaryStreamEncoder endpoint = new WSCClientEndpointWithIOBinaryStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void textStreamEncoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("iotextstreamencoder", (Object)ECHO, "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void textStreamEncoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCClientEndpointWithIOTextStreamEncoder endpoint = new WSCClientEndpointWithIOTextStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simpleecho", new StringBean(ECHO));
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryStreamEncoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("ioreturningbinarystreamencoder", (Object)ECHO, "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void returningBinaryStreamEncoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithIOBinaryStreamEncoder endpoint = new WSCReturningClientEndpointWithIOBinaryStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void returningTextStreamEncoderThrowIOAndCatchOnServerTest() throws Exception {
        this.invoke("ioreturningtextstreamencoder", (Object)ECHO, "TCK IO exception for test");
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    @Test
    public void returningTextStreamEncoderThrowIOAndCatchOnClientTest() throws Exception {
        WSCReturningClientEndpointWithIOTextStreamEncoder endpoint = new WSCReturningClientEndpointWithIOTextStreamEncoder();
        this.setAnnotatedClientEndpoint(endpoint);
        this.invokeIOOnClient("simpleecho", ECHO);
        WSClientIT.logMsg("The IOException has been propagated to @OnError");
    }

    private void invokeOnClient(String endpoint, Object entity) throws Exception {
        this.setCountDownLatchCount(2);
        this.invoke(endpoint, entity, "TCK coder exception for test", "TCK coder exception for test");
    }

    private void invokeIOOnClient(String endpoint, Object entity) throws Exception {
        this.setCountDownLatchCount(2);
        this.invoke(endpoint, entity, "TCK IO exception for test", "TCK IO exception for test");
    }
}

