/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.impl;

import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WaitingSendHandler
implements SendHandler {
    private volatile CountDownLatch latch = new CountDownLatch(1);
    private volatile SendResult result = null;

    public SendResult waitForResult(long seconds) {
        try {
            this.latch.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Wait has been interrupted", e);
        }
        if (this.latch != null && this.latch.getCount() != 0L) {
            throw new IllegalStateException("onResult has not been called on time");
        }
        if (this.result == null) {
            throw new IllegalStateException("SendResult is null");
        }
        return this.result;
    }

    public void onResult(SendResult result) {
        this.result = result;
        this.latch.countDown();
    }
}

