/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ReqBean;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.CronTrigger;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.enterprise.concurrent.ZonedTrigger;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;

@ManagedScheduledExecutorDefinition.List(value={@ManagedScheduledExecutorDefinition(name="java:app/concurrent/ScheduledExecutorA", context="java:app/concurrent/ContextA", maxAsync=3, hungTaskThreshold=360000L), @ManagedScheduledExecutorDefinition(name="java:module/concurrent/ScheduledExecutorB", context="java:module/concurrent/ContextB", maxAsync=4), @ManagedScheduledExecutorDefinition(name="java:comp/concurrent/ScheduledExecutorC")})
@WebServlet(value={"/ManagedScheduledExecutorDefinitionServlet"})
public class ManagedScheduledExecutorDefinitionServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Inject
    private ReqBean reqBean;
    @Resource
    private UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCompletionStageMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        try {
            IntContext.set(100);
            StringContext.set("testAsyncCompletionStageMSE-1");
            CompletionStage future = ((CompletableFuture)executor.supplyAsync(() -> {
                try {
                    ManagedScheduledExecutorService mes = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
                    return "Application context " + (mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            }).applyToEitherAsync((CompletionStage)executor.newIncompleteFuture(), status -> {
                int i = IntContext.get();
                return status + ";IntContext " + (String)(i == 100 ? "propagated" : "incorrect:" + i);
            })).thenApply(status -> {
                String s = StringContext.get();
                return status + ";StringContext " + (String)("".equals(s) ? "cleared" : "incorrect:" + s);
            });
            IntContext.set(200);
            String result = (String)((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)result, (Object)"Application context propagated;IntContext propagated;StringContext cleared", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    public void testAsynchronousMethodRunsWithContext() throws Throwable {
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        this.reqBean.lookUpAContextService().thenAccept(results::add);
        Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        if (result instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError())).initCause((Throwable)result);
        }
        Assertions.assertTrue((boolean)(result instanceof ContextService), (String)"Application context must be propagated to Asynchronous method per @ManagedScheduledExecutorDefinition config.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsynchronousMethodWithMaxAsync3() throws Exception {
        CompletableFuture<String> future4;
        CompletableFuture<String> future3;
        CompletableFuture<String> future2;
        CompletableFuture<String> future1;
        Semaphore invocationsStarted = new Semaphore(0);
        CountDownLatch blocker = new CountDownLatch(1);
        try {
            StringContext.set("testAsynchronousMethodWithMaxAsync3");
            IntContext.set(303);
            future1 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future2 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future3 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future4 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run 1 asynchronous method in parallel when maxAsync=3");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run 2 asynchronous methods in parallel when maxAsync=3");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run 3 asynchronous methods in parallel when maxAsync=3");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, 1L, TimeUnit.SECONDS), (Object)false, (String)"Must not run 4 asynchronous methods in parallel when maxAsync=3");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
            blocker.countDown();
        }
        Assertions.assertEquals((Object)future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on first asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assertions.assertEquals((Object)future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on second asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assertions.assertEquals((Object)future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on third asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assertions.assertEquals((Object)future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on fourth asynchronous method invocation per the executor and ContextServiceDefinition.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompletedFutureMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:module/concurrent/ScheduledExecutorB");
        IntContext.set(41);
        StringContext.set("testCompletedFutureMSE-1");
        try {
            CompletableFuture stage1a = executor.completedFuture((Object)"java:module");
            CompletableFuture stage1b = executor.completedFuture((Object)"concurrent/ScheduledExecutorB");
            IntContext.set(42);
            StringContext.set("testCompletedFutureMSE-2");
            CompletionStage stage2 = stage1a.thenCombineAsync((CompletionStage)stage1b, (part1, part2) -> {
                try {
                    return InitialContext.doLookup(part1 + "/" + part2).toString();
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            try {
                String result = (String)((CompletableFuture)stage2).join();
                throw new AssertionError((Object)("Application context must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config. Instead, was able to look up " + result));
            }
            catch (CompletionException x) {
                if (!(x.getCause() instanceof NamingException)) {
                    throw x;
                }
                IntContext.set(43);
                StringContext.set("testCompletedFutureMSE-3");
                CompletionStage stage3 = ((CompletableFuture)stage2).exceptionally(failure -> {
                    int i = IntContext.get();
                    String s = StringContext.get();
                    if (failure instanceof CompletionException && failure.getCause() instanceof NamingException) {
                        return "StringContext " + (String)("testCompletedFutureMSE-3".equals(s) ? "propagated" : "incorrect:" + s) + ";IntContext " + (String)(i == 43 ? "unchanged" : "incorrect:" + i);
                    }
                    if (failure == null) {
                        throw new AssertionError((Object)"Missing Throwable argument to exceptionally");
                    }
                    throw new CompletionException((Throwable)failure);
                });
                StringContext.set("testCompletedFutureMSE-4");
                String result = (String)((CompletableFuture)stage3).join();
                Assertions.assertEquals((Object)result, (Object)"StringContext propagated;IntContext unchanged", (String)"StringContext must be propagated and Application context and IntContext must be left unchanged per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
                IntContext.set(0);
                StringContext.set(null);
            }
        }
        catch (Throwable throwable) {
            IntContext.set(0);
            StringContext.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteFutureMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        StringBuilder results = new StringBuilder();
        try {
            IntContext.set(91);
            StringContext.set("testIncompleteFutureMSE-1");
            CompletableFuture stage1a = executor.newIncompleteFuture();
            CompletableFuture stage1b = executor.newIncompleteFuture();
            IntContext.set(92);
            CompletionStage stage2 = stage1a.thenAcceptBothAsync((CompletionStage)stage1b, (part1, part2) -> {
                try {
                    ManagedScheduledExecutorService mes = (ManagedScheduledExecutorService)InitialContext.doLookup(part1 + "/" + part2);
                    results.append("Application context ").append(mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
                String s = StringContext.get();
                results.append(";StringContext ").append((String)("".equals(s) ? "cleared" : "incorrect:" + s));
            });
            IntContext.set(93);
            CompletionStage stage3 = ((CompletableFuture)stage2).runAfterBothAsync((CompletionStage)stage1b, () -> {
                int i = IntContext.get();
                results.append(";IntContext ").append((String)(i == 93 ? "propagated" : "incorrect:" + i));
            });
            stage1a.complete("java:app");
            stage1b.complete("concurrent/ScheduledExecutorA");
            Assertions.assertEquals(((CompletableFuture)stage3).join(), null, (String)"CompletableFuture with Void return type must return null from join.");
            String result = results.toString();
            Assertions.assertEquals((Object)result, (Object)"Application context propagated;StringContext cleared;IntContext propagated", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionAllAttributes() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        try {
            IntContext.set(33);
            executor.execute(task);
            executor.runAsync(task);
            executor.submit(task);
            executor.submit(task, (Object)"TaskResult");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run an async task.");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 2 async tasks concurrently.");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 3 async tasks concurrently.");
            Assertions.assertEquals((Integer)((Integer)results.poll(1L, TimeUnit.SECONDS)), null, (String)"ManagedScheduledExecutorService with maxAsync=3 must not run 4 async tasks concurrently.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 4th task after 1st completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionDefaults() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        CountDownLatch blocker = new CountDownLatch(1);
        CountDownLatch allTasksRunning = new CountDownLatch(4);
        Callable<Integer> txCallable = () -> {
            allTasksRunning.countDown();
            UserTransaction trans = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            int initialStatus = trans.getStatus();
            trans.begin();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            finally {
                trans.rollback();
            }
            return initialStatus;
        };
        Function<String, Object> lookupFunction = jndiName -> {
            allTasksRunning.countDown();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                return InitialContext.doLookup(jndiName);
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
        };
        try {
            Future txFuture1 = executor.submit(txCallable);
            Future txFuture2 = executor.submit(txCallable);
            CompletionStage lookupFuture1 = executor.completedFuture((Object)"java:comp/concurrent/ScheduledExecutorC").thenApplyAsync(lookupFunction);
            CompletionStage lookupFuture2 = executor.completedFuture((Object)"java:module/concurrent/ScheduledExecutorB").thenApplyAsync(lookupFunction);
            Assertions.assertTrue((boolean)allTasksRunning.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedScheduledExecutorService without maxAsync must be able to run async tasks concurrently.");
            blocker.countDown();
            int status = (Integer)txFuture1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from first async Callable task per java:comp/concurrent/ScheduledExecutorC configuration.");
            status = (Integer)txFuture2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from second async Callable task per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture1).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first async Function per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture2).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second async Function per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        this.tx.begin();
        try {
            int status = (Integer)executor.getContextService().contextualCallable(txCallable).call();
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from inline contextual Callable per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            this.tx.rollback();
        }
    }

    public void testNotAnAsynchronousMethod() throws Throwable {
        String threadName = Thread.currentThread().getName();
        CompletableFuture<String> future = this.reqBean.notAsynchronous();
        Assertions.assertEquals((Object)future.join(), (Object)threadName, (String)"A method that returns CompletableFuture but is not annotated as @Asynchronous must run inline on the same thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduleWithCronTrigger() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        ZoneId usCentral = ZoneId.of("America/Chicago");
        ZoneId usMountain = ZoneId.of("America/Denver");
        CronTrigger everyOtherSecond = new CronTrigger("*/2 * * * JAN-DEC SUN-SAT", usCentral);
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        ScheduledFuture future = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)everyOtherSecond);
        try {
            CronTrigger weekendsAtNoon6MonthsFromNow = new CronTrigger(usMountain).daysOfWeek(new DayOfWeek[]{DayOfWeek.SATURDAY, DayOfWeek.SUNDAY}).hours(new int[]{12}).months(new Month[]{ZonedDateTime.now(usMountain).plusMonths(6L).getMonth()});
            ScheduledFuture distantFuture = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)weekendsAtNoon6MonthsFromNow);
            long days = distantFuture.getDelay(TimeUnit.DAYS);
            Assertions.assertTrue((days > 140L ? 1 : 0) != 0, (String)("Too few days (" + days + ") until the next execution of " + weekendsAtNoon6MonthsFromNow + " which is used by " + distantFuture));
            Assertions.assertTrue((days < 190L ? 1 : 0) != 0, (String)("Too many days (" + days + ") until the next execution of " + weekendsAtNoon6MonthsFromNow + " which is used by " + distantFuture));
            Assertions.assertTrue((boolean)distantFuture.cancel(true), (String)("Must be able to cancel a repeating task before it runs: " + future));
            Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not run: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not repeat: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not run 3 times: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to third execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assertions.assertTrue((boolean)future.cancel(true), (String)("Must be able to cancel a repeating task after it executes a few times: " + future));
        }
        finally {
            if (!future.isDone()) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduleWithZonedTrigger() throws Exception {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        final ZoneId usCentral = ZoneId.of("America/Chicago");
        final ConcurrentHashMap startAndEndTimes = new ConcurrentHashMap();
        ZonedTrigger monthlyOnThe15th = new ZonedTrigger(){
            private final Map<Long, ZonedDateTime> schedule = new ConcurrentHashMap<Long, ZonedDateTime>();

            private void initSchedule() {
                ZonedDateTime sept15 = ZonedDateTime.of(2021, 9, 15, 8, 0, 0, 0, usCentral);
                ZonedDateTime oct15 = ZonedDateTime.of(2021, 10, 15, 8, 0, 0, 0, usCentral);
                ZonedDateTime nov15 = ZonedDateTime.of(2021, 11, 15, 8, 0, 0, 0, usCentral);
                this.schedule.put(0L, sept15);
                this.schedule.put(sept15.toEpochSecond(), oct15);
                this.schedule.put(oct15.toEpochSecond(), nov15);
            }

            public ZonedDateTime getNextRunTime(LastExecution lastExecution, ZonedDateTime scheduledAt) {
                if (lastExecution == null) {
                    this.initSchedule();
                } else {
                    startAndEndTimes.put(lastExecution.getRunStart(usCentral), lastExecution.getRunEnd(usCentral));
                }
                long key = lastExecution == null ? 0L : lastExecution.getScheduledStart(usCentral).toEpochSecond();
                return this.schedule.get(key);
            }

            public ZoneId getZoneId() {
                return usCentral;
            }
        };
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        ScheduledFuture future = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)monthlyOnThe15th);
        try {
            Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not run: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not repeat: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not run 3 times: " + future));
            Assertions.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to third execution per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            if (!future.isDone()) {
                future.cancel(true);
            }
        }
        for (Map.Entry entry : startAndEndTimes.entrySet()) {
            ZonedDateTime endAt;
            ZonedDateTime startAt = (ZonedDateTime)entry.getKey();
            Assertions.assertTrue((startAt.isBefore(endAt = (ZonedDateTime)entry.getValue()) || startAt.isEqual(endAt) ? 1 : 0) != 0, (String)("LastExecution runStart and runEnd methods returned inconsistent times: " + startAndEndTimes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedFuture() throws Throwable {
        CompletableFuture<Integer> future;
        AtomicInteger counter = new AtomicInteger();
        try {
            future = this.reqBean.scheduledEvery5seconds(1, ReqBean.RETURN.INCOMPLETE, counter);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(10L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertEquals((int)1, (int)counter.get(), (String)"Schedule should have executed exactly once.");
            future.cancel(false);
        }
        finally {
            counter.set(0);
        }
        try {
            future = this.reqBean.scheduledEvery5seconds(1, ReqBean.RETURN.NULL, counter);
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertFalse((boolean)future.isDone());
            int countBeforeCancel = counter.get();
            future.cancel(false);
            Assertions.assertThrows(CancellationException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            int countAfterCancel = counter.get();
            Assertions.assertTrue((countAfterCancel - countBeforeCancel <= 1 ? 1 : 0) != 0, (String)"Schedule should not have executed more than once after cancel was called.");
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedResult() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            int expected = 3;
            CompletableFuture<Integer> future = this.reqBean.scheduledEvery5seconds(expected, ReqBean.RETURN.COMPLETE_RESULT, counter);
            int result = future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertEquals((int)expected, (int)result);
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedExceptionally() {
        ExecutionException cause;
        CompletableFuture<Integer> future;
        String expected;
        AtomicInteger counter = new AtomicInteger();
        try {
            expected = "testScheduledAsynchCompletedExceptionally-1";
            future = this.reqBean.scheduledEvery5seconds(1, ReqBean.RETURN.COMPLETE_EXCEPTIONALLY.withMessage(expected), counter);
            cause = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)cause.getMessage().contains(expected));
            Assertions.assertEquals((int)1, (int)counter.get(), (String)"Schedule should have executed exactly once.");
        }
        finally {
            counter.set(0);
        }
        try {
            expected = "testScheduledAsynchCompletedExceptionally-2";
            future = this.reqBean.scheduledEvery5seconds(1, ReqBean.RETURN.THROW_EXCEPTION.withMessage(expected), counter);
            cause = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)cause.getMessage().contains(expected));
            Assertions.assertEquals((int)1, (int)counter.get());
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchOverlapSkipping() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            int expected = 3;
            CompletableFuture<Integer> future = this.reqBean.scheduledEvery3SecondsTakes5Seconds(expected, counter);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(expected * 3, TimeUnit.SECONDS));
            int result = future.get(expected * 5, TimeUnit.SECONDS);
            Assertions.assertEquals((int)expected, (int)result);
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchIgnoresMaxAsync() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:module/concurrent/ScheduledExecutorB");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        AtomicInteger counter = new AtomicInteger();
        try {
            IntContext.set(22);
            executor.runAsync(task);
            executor.runAsync(task);
            executor.runAsync(task);
            executor.runAsync(task);
            executor.runAsync(task);
            CompletableFuture<Integer> future = this.reqBean.scheduledEvery3Seconds(1, counter);
            Assertions.assertEquals((Integer)0, (Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"ManagedScheduledExecutorService with maxAsync=4 must be able to run one async task.");
            Assertions.assertEquals((Integer)0, (Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"ManagedScheduledExecutorService with maxAsync=4 must be able to run two async tasks.");
            Assertions.assertEquals((Integer)0, (Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"ManagedScheduledExecutorService with maxAsync=4 must be able to run three async tasks.");
            Assertions.assertEquals((Integer)0, (Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"ManagedScheduledExecutorService with maxAsync=4 must be able to run four async tasks.");
            Assertions.assertEquals(null, (Integer)((Integer)results.poll(1L, TimeUnit.SECONDS)), (String)"ManagedScheduledExecutorService with maxAsync=4 must not run 5 async tasks concurrently.");
            Assertions.assertEquals((Integer)0, (Integer)future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedScheduledExecutorService with maxAsync=4 must be able to run scheduled async methods concurrently.");
        }
        finally {
            IntContext.set(0);
            counter.set(0);
            blocker.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchWithMultipleSchedules() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            String expected = "testScheduledAsynchWithMultipleSchedules";
            StringContext.set(expected);
            CompletableFuture<String> future = this.reqBean.scheduledEvery3SecondsAnd1Minute(5, counter);
            String result = future.get(1L, TimeUnit.MINUTES);
            Assertions.assertEquals((Object)expected, (Object)result);
        }
        finally {
            StringContext.set(null);
            counter.set(0);
        }
    }

    public void testScheduledAsynchWithInvalidJNDIName() {
        Assertions.assertThrows(RejectedExecutionException.class, () -> this.reqBean.scheduledInvalidExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchVoidReturn() {
        int expected;
        AtomicInteger counter = new AtomicInteger();
        try {
            expected = 3;
            this.reqBean.scheduledEvery3SecondsVoidReturn(expected, ReqBean.RETURN.COMPLETE_RESULT, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
        try {
            expected = 3;
            this.reqBean.scheduledEvery3SecondsVoidReturn(expected, ReqBean.RETURN.COMPLETE_EXCEPTIONALLY, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
        try {
            expected = 3;
            this.reqBean.scheduledEvery3SecondsVoidReturn(expected, ReqBean.RETURN.THROW_EXCEPTION, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
    }
}

