/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.internal.renderers.IEditorRendererExtensionRegistry;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.swt.graphics.Image;

public class IntentImageAnnotation
extends Annotation {
    private Image image;
    private ExternalContentReference reference;
    private boolean imageShouldBeRedrawn;

    public IntentImageAnnotation(ExternalContentReference reference) {
        super("org.eclipse.mylyn.docs.intent.client.ui.annotation.image", false, "");
        this.reference = reference;
    }

    public Image getImage() {
        return this.getImage(true);
    }

    public Image getImage(boolean createImageIfNotExists) {
        if (this.image != null && this.image.isDisposed()) {
            this.image = null;
        }
        if (createImageIfNotExists && (this.imageShouldBeRedrawn || this.image == null)) {
            if (this.image != null) {
                this.image.dispose();
            }
            for (IEditorRendererExtension rendererExtension : IEditorRendererExtensionRegistry.getEditorRendererExtensions(this.reference)) {
                this.image = rendererExtension.getImage(this.reference);
                if (this.image == null) continue;
                this.imageShouldBeRedrawn = false;
                break;
            }
        }
        return this.image;
    }

    public ExternalContentReference getExternalContentReference() {
        return this.reference;
    }

    public void setImageShouldBeRedrawn(boolean imageShouldBeRedrawn) {
        this.imageShouldBeRedrawn = imageShouldBeRedrawn;
    }
}

