/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.utils;

import org.eclipse.emf.compare.utils.DiffUtil;

public final class StringDistanceUtils {
    private static final double DEFAULT_MAX_STRING_DISTANCE = 500.0;
    private static final double DEFAULT_STRING_SIZE_DISTANCE_IMPACT = 0.7;
    private static final double DEFAULT_STRING_DICE_DISTANCE_IMPACT = 0.3;

    private StringDistanceUtils() {
    }

    public static Double getStringDistance(String a, String b) {
        return StringDistanceUtils.getStringDistance(a, b, 0.3, 0.7);
    }

    public static Double getStringDistance(String a, String b, double diceDistanceImpact, double sizeDistanceImpact) {
        if (diceDistanceImpact + sizeDistanceImpact != 1.0) {
            throw new AssertionError((Object)("dice and size impacts sum must be equal to 1, currently " + diceDistanceImpact + sizeDistanceImpact));
        }
        Double res = 500.0;
        if (a != null && b != null) {
            double sizeCoeff = 1.0 - 2.0 * (double)Math.abs(a.length() - b.length()) / (double)(a.length() + b.length());
            double diceCoefficient = DiffUtil.diceCoefficient((String)a, (String)b);
            double average = diceCoefficient * diceDistanceImpact + sizeCoeff * sizeDistanceImpact;
            res = (1.0 - average) * 500.0;
        } else if (a == null && b == null) {
            res = new Double(0.0);
        }
        return res;
    }
}

