/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentFeatureFilter
extends FeatureFilter {
    private static final Collection<EStructuralFeature> FEATURES_TO_IGNORE = IntentFeatureFilter.getFeaturesToIgnore();

    protected boolean isIgnoredReference(Match match, EReference reference) {
        return super.isIgnoredReference(match, reference) || FEATURES_TO_IGNORE.contains(reference);
    }

    protected boolean isIgnoredAttribute(EAttribute attribute) {
        return super.isIgnoredAttribute(attribute) || FEATURES_TO_IGNORE.contains(attribute);
    }

    protected static Collection<EStructuralFeature> getFeaturesToIgnore() {
        ArrayList featuresToIgnoreList = Lists.newArrayList();
        featuresToIgnoreList.add(IntentDocumentPackage.eINSTANCE.getIntentGenericElement_CompilationStatus());
        featuresToIgnoreList.add(IntentDocumentPackage.eINSTANCE.getIntentStructuredElement_CompleteLevel());
        featuresToIgnoreList.add(ModelingUnitPackage.eINSTANCE.getExternalContentReference_ExternalContent());
        featuresToIgnoreList.add(ModelingUnitPackage.eINSTANCE.getExternalContentReference_MarkedAsMerged());
        return featuresToIgnoreList;
    }
}

