/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;

public class IntentPositionManager {
    private Map<EObject, ParsedElementPosition> instructionToPosition = new HashMap<EObject, ParsedElementPosition>();
    private Map<EObject, ParsedElementPosition> instructionToDeclarationPosition = new HashMap<EObject, ParsedElementPosition>();
    private SortedMap<Integer, EObject> positionToInstruction = new TreeMap<Integer, EObject>();
    private Map<EObject, Integer> elementToIndentationLevel = new HashMap<EObject, Integer>();

    public void clear() {
        this.instructionToPosition.clear();
        this.instructionToDeclarationPosition.clear();
        this.positionToInstruction.clear();
        this.elementToIndentationLevel.clear();
    }

    public ParsedElementPosition getPositionForElement(EObject instruction) {
        if (this.instructionToDeclarationPosition.get(instruction) != null) {
            return this.instructionToDeclarationPosition.get(instruction);
        }
        return this.instructionToPosition.get(instruction);
    }

    public EObject getElementAtPosition(int offset) {
        EObject foundElement = null;
        Iterator<Integer> offsetIterator = this.positionToInstruction.keySet().iterator();
        Integer currentOffsetValue = 0;
        while (currentOffsetValue < offset && offsetIterator.hasNext()) {
            currentOffsetValue = offsetIterator.next();
            foundElement = (EObject)this.positionToInstruction.get(currentOffsetValue);
        }
        return foundElement;
    }

    public void addIntentPositionManagerInformations(IntentPositionManager positionManager) {
        this.instructionToPosition.putAll(positionManager.instructionToPosition);
        this.instructionToDeclarationPosition.putAll(positionManager.instructionToDeclarationPosition);
        this.positionToInstruction.putAll(positionManager.positionToInstruction);
        this.elementToIndentationLevel.putAll(positionManager.elementToIndentationLevel);
    }

    public void setPositionForInstruction(EObject instruction, int offset, int length) {
        this.instructionToPosition.put(instruction, new ParsedElementPosition(offset, length));
        this.positionToInstruction.put(offset, instruction);
    }

    public void setDeclarationPositionForInstruction(EObject instruction, int offset, int length, int declarationLength) {
        this.instructionToPosition.put(instruction, new ParsedElementPosition(offset, length));
        this.instructionToDeclarationPosition.put(instruction, new ParsedElementPosition(offset, declarationLength));
        this.positionToInstruction.put(offset, instruction);
    }

    public void handleTabulations(int tabOffset, int nbTabs) {
        Iterator<Integer> offsetIterator = this.positionToInstruction.keySet().iterator();
        Integer currentOffsetValue = 0;
        HashMap<Integer, EObject> newPositionToInstructions = new HashMap<Integer, EObject>();
        while (offsetIterator.hasNext()) {
            currentOffsetValue = offsetIterator.next();
            if (currentOffsetValue < tabOffset) continue;
            EObject movedElement = (EObject)this.positionToInstruction.get(currentOffsetValue);
            newPositionToInstructions.put(currentOffsetValue + nbTabs, movedElement);
            ParsedElementPosition position = this.instructionToPosition.get(movedElement);
            ParsedElementPosition newPosition = new ParsedElementPosition(position.getOffset() + nbTabs, position.getLength());
            this.instructionToPosition.put(movedElement, newPosition);
            if (this.instructionToDeclarationPosition.get(movedElement) == null) continue;
            ParsedElementPosition declarationPosition = this.instructionToDeclarationPosition.get(movedElement);
            ParsedElementPosition newDeclarationPosition = new ParsedElementPosition(declarationPosition.getOffset() + nbTabs, declarationPosition.getLength());
            this.instructionToDeclarationPosition.put(movedElement, newDeclarationPosition);
        }
        for (Integer newOffset : newPositionToInstructions.keySet()) {
            this.positionToInstruction.remove(newOffset - nbTabs);
            this.positionToInstruction.put(newOffset, (EObject)newPositionToInstructions.get(newOffset));
        }
    }

    public void setIndentationLevel(EObject element, int indentationLevel) {
        this.elementToIndentationLevel.put(element, indentationLevel);
    }

    public int getIndentationLevel(EObject element) {
        if (this.elementToIndentationLevel.get(element) != null) {
            return this.elementToIndentationLevel.get(element);
        }
        return -1;
    }

    @Deprecated
    public String toString() {
        String rF = "";
        for (Integer pos : this.positionToInstruction.keySet()) {
            rF = String.valueOf(rF) + "-" + pos + "=>" + this.positionToInstruction.get(pos) + "\n";
        }
        return rF;
    }
}

