/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import org.eclipse.handly.util.LruCache;

public class BoundedLruCache<K, V>
extends LruCache<K, V> {
    private int maxSize;

    public BoundedLruCache(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
    }

    public final int maxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
        if (this.size() > maxSize) {
            this.makeSpace(0);
        }
    }

    @Override
    protected void add(LruCache.Entry<K, V> entry) {
        if (this.size() + 1 > this.maxSize) {
            this.makeSpace(1);
        }
        super.add(entry);
    }

    protected void makeSpace(int sizeNeeded) {
        LruCache.Entry entry = this.getLruEntry();
        while (entry != null && sizeNeeded > this.maxSize - this.size()) {
            this.evict(entry);
            entry = this.existingPrev(entry);
        }
    }

    private LruCache.Entry<K, V> existingPrev(LruCache.Entry<K, V> entry) {
        LruCache.Entry<K, V> e = entry.prev();
        while (e != null && this.entryByKey(e.key) == null) {
            e = e.prev();
        }
        return e;
    }

    protected void evict(LruCache.Entry<K, V> entry) {
        this.doRemove(entry);
    }
}

