/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf;

import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.gmf.ApplyLayoutRequest;
import de.cau.cs.kieler.kiml.gmf.GmfLayoutCommand;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;

public class GmfLayoutEditPolicy
extends AbstractEditPolicy {
    private Map<KEdgeLayout, PointList> pointListMap = new HashMap<KEdgeLayout, PointList>();
    private static final int SOURCE_LOCATION = 85;
    private static final int MIDDLE_LOCATION = 50;
    private static final int TARGET_LOCATION = 15;
    private static final String SPLINE_CONNECTION = "de.cau.cs.kieler.core.model.gmf.figures.SplineConnection";

    public boolean understandsRequest(Request req) {
        return "apply layout".equals(req.getType());
    }

    public Command getCommand(Request request) {
        if ("apply layout".equals(request.getType())) {
            if (request instanceof ApplyLayoutRequest) {
                ApplyLayoutRequest layoutRequest = (ApplyLayoutRequest)request;
                IGraphicalEditPart hostEditPart = (IGraphicalEditPart)this.getHost();
                GmfLayoutCommand command = new GmfLayoutCommand(hostEditPart.getEditingDomain(), Messages.getString((String)"kiml.ui.5"), (IAdaptable)new EObjectAdapter((EObject)((View)hostEditPart.getModel())));
                float xbound = layoutRequest.getXBound();
                float ybound = layoutRequest.getYBound();
                float scale = layoutRequest.getScale();
                for (Pair<KGraphElement, GraphicalEditPart> layoutPair : layoutRequest.getElements()) {
                    if (layoutPair.getFirst() instanceof KNode) {
                        this.addShapeLayout(command, (KGraphElement)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof KPort) {
                        this.addShapeLayout(command, (KGraphElement)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof KEdge) {
                        this.addEdgeLayout(command, (KEdge)layoutPair.getFirst(), (ConnectionEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (!(layoutPair.getFirst() instanceof KLabel)) continue;
                    this.addLabelLayout(command, (KLabel)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), xbound, ybound, scale);
                }
                IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
                command.setObliqueRouting(preferenceStore.getBoolean("kiml.oblique.route"));
                this.pointListMap.clear();
                return new ICommandProxy((ICommand)command);
            }
            return null;
        }
        return super.getCommand(request);
    }

    private void addShapeLayout(GmfLayoutCommand command, KGraphElement kgraphElement, GraphicalEditPart editPart, float scale) {
        KShapeLayout layoutData = (KShapeLayout)kgraphElement.getData(KShapeLayout.class);
        View view = (View)editPart.getModel();
        Point newLocation = new Point((int)(layoutData.getXpos() * scale), (int)(layoutData.getYpos() * scale));
        Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        if (oldx != null && oldy != null && newLocation.x == (Integer)oldx && newLocation.y == (Integer)oldy) {
            newLocation = null;
        }
        Dimension newSize = new Dimension((int)(layoutData.getWidth() * scale), (int)(layoutData.getHeight() * scale));
        Object oldWidth = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Object oldHeight = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (oldWidth != null && oldHeight != null && newSize.width == (Integer)oldWidth && newSize.height == (Integer)oldHeight) {
            newSize = null;
        }
        if (newLocation != null || newSize != null) {
            command.addShapeLayout(view, newLocation, newSize);
        }
    }

    private void addEdgeLayout(GmfLayoutCommand command, KEdge kedge, ConnectionEditPart connectionEditPart, double scale) {
        if (connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null) {
            SlidableAnchor targetAnchor;
            SlidableAnchor sourceAnchor;
            INodeEditPart sourceEditPart = (INodeEditPart)connectionEditPart.getSource();
            if (sourceEditPart instanceof ConnectionEditPart) {
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure());
            } else {
                KVector sourceRel = this.getRelativeSourcePoint(kedge);
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure(), new PrecisionPoint(sourceRel.x, sourceRel.y));
            }
            String sourceTerminal = sourceEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)sourceAnchor);
            INodeEditPart targetEditPart = (INodeEditPart)connectionEditPart.getTarget();
            if (targetEditPart instanceof ConnectionEditPart) {
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure());
            } else {
                KVector targetRel = this.getRelativeTargetPoint(kedge);
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure(), new PrecisionPoint(targetRel.x, targetRel.y));
            }
            String targetTerminal = targetEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)targetAnchor);
            PointList bendPoints = this.getBendPoints(kedge, connectionEditPart.getFigure(), scale);
            if (sourceEditPart instanceof ConnectionEditPart || targetEditPart instanceof ConnectionEditPart) {
                while (bendPoints.size() > 2) {
                    bendPoints.removePoint(1);
                }
            }
            command.addEdgeLayout((Edge)connectionEditPart.getModel(), bendPoints, sourceTerminal, targetTerminal);
        }
    }

    private KVector getRelativeSourcePoint(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KNode sourceNode = edge.getSource();
        KNode targetNode = edge.getTarget();
        KPoint sourcePoint = edgeLayout.getSourcePoint();
        KVector sourceRel = sourcePoint.createVector();
        KShapeLayout sourceLayout = (KShapeLayout)sourceNode.getData(KShapeLayout.class);
        if (KimlUtil.isDescendant((KNode)targetNode, (KNode)sourceNode)) {
            this.translateDescendantPoint(sourceRel, sourceLayout);
        } else {
            sourceRel.translate((double)(-sourceLayout.getXpos()), (double)(-sourceLayout.getYpos()));
        }
        if (edge.getSourcePort() != null) {
            KShapeLayout portLayout = (KShapeLayout)edge.getSourcePort().getData(KShapeLayout.class);
            sourceRel.x = portLayout.getWidth() <= 0.0f ? 0.0 : (sourceRel.x - (double)portLayout.getXpos()) / (double)portLayout.getWidth();
            sourceRel.y = portLayout.getHeight() <= 0.0f ? 0.0 : (sourceRel.y - (double)portLayout.getYpos()) / (double)portLayout.getHeight();
        } else {
            sourceRel.x = sourceLayout.getWidth() <= 0.0f ? 0.0 : (sourceRel.x /= (double)sourceLayout.getWidth());
            sourceRel.y = sourceLayout.getHeight() <= 0.0f ? 0.0 : (sourceRel.y /= (double)sourceLayout.getHeight());
        }
        return sourceRel.applyBounds(0.0, 0.0, 1.0, 1.0);
    }

    private KVector getRelativeTargetPoint(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KNode sourceNode = edge.getSource();
        KNode targetNode = edge.getTarget();
        KPoint targetPoint = edgeLayout.getTargetPoint();
        KVector targetRel = targetPoint.createVector();
        KShapeLayout targetLayout = (KShapeLayout)targetNode.getData(KShapeLayout.class);
        if (KimlUtil.isDescendant((KNode)targetNode, (KNode)sourceNode)) {
            if (sourceNode != targetNode.getParent()) {
                KimlUtil.toAbsolute((KVector)targetRel, (KNode)sourceNode);
                KimlUtil.toRelative((KVector)targetRel, (KNode)targetNode.getParent());
            }
            targetRel.translate((double)(-targetLayout.getXpos()), (double)(-targetLayout.getYpos()));
        } else if (sourceNode.getParent() != targetNode.getParent()) {
            KimlUtil.toAbsolute((KVector)targetRel, (KNode)sourceNode.getParent());
            KimlUtil.toRelative((KVector)targetRel, (KNode)targetNode.getParent());
            targetRel.translate((double)(-targetLayout.getXpos()), (double)(-targetLayout.getYpos()));
        } else {
            targetRel.translate((double)(-targetLayout.getXpos()), (double)(-targetLayout.getYpos()));
        }
        if (edge.getTargetPort() != null) {
            KShapeLayout portLayout = (KShapeLayout)edge.getTargetPort().getData(KShapeLayout.class);
            targetRel.x = portLayout.getWidth() <= 0.0f ? 0.0 : (targetRel.x - (double)portLayout.getXpos()) / (double)portLayout.getWidth();
            targetRel.y = portLayout.getHeight() <= 0.0f ? 0.0 : (targetRel.y - (double)portLayout.getYpos()) / (double)portLayout.getHeight();
        } else {
            targetRel.x = targetLayout.getWidth() <= 0.0f ? 0.0 : (targetRel.x /= (double)targetLayout.getWidth());
            targetRel.y = targetLayout.getHeight() <= 0.0f ? 0.0 : (targetRel.y /= (double)targetLayout.getHeight());
        }
        return targetRel.applyBounds(0.0, 0.0, 1.0, 1.0);
    }

    private void translateDescendantPoint(KVector point, KShapeLayout layout) {
        KInsets insets = layout.getInsets();
        point.x += (double)insets.getLeft();
        point.y += (double)insets.getTop();
    }

    private void addLabelLayout(GmfLayoutCommand command, KLabel klabel, GraphicalEditPart labelEditPart, float xbound, float ybound, double scale) {
        int fromEnd;
        KLabeledGraphElement parent = klabel.getParent();
        KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
        if (parent instanceof KNode || parent instanceof KPort) {
            View view = (View)labelEditPart.getModel();
            int xpos = (int)((double)labelLayout.getXpos() * scale);
            int ypos = (int)((double)labelLayout.getYpos() * scale);
            Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            if (oldx == null || oldy == null || xpos != (Integer)oldx || ypos != (Integer)oldy) {
                command.addShapeLayout(view, new Point(xpos, ypos), null);
            }
            return;
        }
        Rectangle targetBounds = new Rectangle(labelEditPart.getFigure().getBounds());
        targetBounds.x = (int)((double)labelLayout.getXpos() * scale);
        targetBounds.y = (int)((double)labelLayout.getYpos() * scale);
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)labelEditPart.getParent();
        PointList bendPoints = this.getBendPoints((KEdge)parent, connectionEditPart.getFigure(), scale);
        EObject modelElement = connectionEditPart.getNotationView().getElement();
        EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT);
        if (modelElement instanceof EReference && labelPlacement == EdgeLabelPlacement.TAIL) {
            bendPoints = bendPoints.getCopy();
            bendPoints.reverse();
        }
        int keyPoint = 4;
        if (labelEditPart instanceof LabelEditPart) {
            keyPoint = ((LabelEditPart)labelEditPart).getKeyPoint();
        }
        switch (keyPoint) {
            case 2: {
                fromEnd = 85;
                break;
            }
            case 3: {
                fromEnd = 15;
                break;
            }
            default: {
                fromEnd = 50;
            }
        }
        Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)bendPoints, (int)0, (int)fromEnd, (boolean)true);
        Point normalPoint = GmfLayoutEditPolicy.offsetFromRelativeCoordinate(targetBounds, bendPoints, refPoint);
        if (normalPoint != null) {
            command.addShapeLayout((View)labelEditPart.getModel(), normalPoint, null);
        }
    }

    private PointList getBendPoints(KEdge edge, IFigure edgeFigure, double scale) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        PointList pointList = this.pointListMap.get(edgeLayout);
        if (pointList == null) {
            KVectorChain bendPoints = edgeLayout.createVectorChain();
            boolean approx = GmfLayoutEditPolicy.handleSplineConnection(edgeFigure, (EdgeRouting)edgeLayout.getProperty(LayoutOptions.EDGE_ROUTING));
            if (approx && bendPoints.size() >= 1) {
                bendPoints = KielerMath.approximateSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(scale);
            pointList = new PointList(bendPoints.size() + 2);
            for (KVector bendPoint : bendPoints) {
                pointList.addPoint((int)bendPoint.x, (int)bendPoint.y);
            }
            this.pointListMap.put(edgeLayout, pointList);
        }
        return pointList;
    }

    private static boolean handleSplineConnection(IFigure edgeFigure, EdgeRouting edgeRouting) {
        boolean isSC;
        Class<?> clazz = edgeFigure.getClass();
        do {
            isSC = clazz.getCanonicalName().equals(SPLINE_CONNECTION);
            clazz = clazz.getSuperclass();
        } while (!isSC && clazz != null);
        if (isSC) {
            clazz = edgeFigure.getClass();
            try {
                if (edgeRouting == EdgeRouting.SPLINES) {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 1);
                } else {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 0);
                }
                return false;
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
        return edgeRouting == EdgeRouting.SPLINES;
    }

    public static Point offsetFromRelativeCoordinate(Rectangle bounds, PointList points, Point therefPoint) {
        Point refPoint = therefPoint;
        if (refPoint == null) {
            refPoint = points.getFirstPoint();
        }
        bounds.translate(bounds.width / 2, bounds.height / 2);
        Point offset = new Point(bounds.x - refPoint.x, bounds.y - refPoint.y);
        if (points.size() == 1) {
            return offset;
        }
        if (points.size() >= 2) {
            int segIndex = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)points, (Point)refPoint);
            List segmentsList = PointListUtilities.getLineSegments((PointList)points);
            segIndex = segIndex <= 0 ? 0 : (segIndex > segmentsList.size() ? segmentsList.size() - 1 : --segIndex);
            LineSeg segment = (LineSeg)segmentsList.get(segIndex);
            Point normalOffset = null;
            if (segment.isHorizontal()) {
                if (segment.getOrigin().x > segment.getTerminus().x) {
                    normalOffset = offset.getNegated();
                    return normalOffset;
                }
                normalOffset = offset;
                return normalOffset;
            }
            if (segment.isVertical()) {
                if (segment.getOrigin().y < segment.getTerminus().y) {
                    normalOffset = offset.scale(-1.0, 1.0).transpose();
                    return normalOffset;
                }
                normalOffset = offset.scale(1.0, -1.0).transpose();
                return normalOffset;
            }
            Point offsetRefPoint = refPoint.getTranslated(offset);
            LineSeg parallelSeg = segment.getParallelLineSegThroughPoint(offsetRefPoint);
            Point p1 = parallelSeg.perpIntersect(refPoint.x, refPoint.y);
            double dx = p1.getDistance(offsetRefPoint) * (double)(p1.x > offsetRefPoint.x ? -1 : 1);
            double dy = p1.getDistance(refPoint) * (double)(p1.y < refPoint.y ? -1 : 1);
            PrecisionPoint orth = new PrecisionPoint(dx, dy);
            if (segment.getOrigin().x > segment.getTerminus().x) {
                orth = orth.scale(-1.0, -1.0);
            }
            return orth;
        }
        return null;
    }
}

