/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphviz.layouter.preferences;

import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.graphviz.layouter.GraphvizLayouterPlugin;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GraphvizPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "de.cau.cs.kieler.kiml.graphviz.preferences";
    private static final int NUM_COLUMNS = 3;
    private static final int LABEL_WIDTH = 450;

    public GraphvizPreferencePage() {
        super(0);
        this.setDescription("Preferences for the Graphviz layouter.");
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Group processGroup = new Group(parent, 0);
        processGroup.setText("Graphviz Process");
        Label label = new Label((Composite)processGroup, 64);
        label.setText("The Graphviz layout tool is available at http://www.graphviz.org/. If the 'dot' executable cannot be found in default locations, its path must be entered here.");
        GridData labelLayoutData = new GridData(16384, 4, false, false, 3, 1);
        labelLayoutData.widthHint = 450;
        label.setLayoutData((Object)labelLayoutData);
        FileFieldEditor executableEditor = new FileFieldEditor("graphviz.executable", "Set path to the 'dot' executable:", (Composite)processGroup);
        executableEditor.setValidateStrategy(0);
        this.addField((FieldEditor)executableEditor);
        IntegerFieldEditor timeoutEditor = new IntegerFieldEditor("graphviz.timeout", "Timeout for Graphviz output (ms):", (Composite)processGroup);
        timeoutEditor.setValidRange(200, Integer.MAX_VALUE);
        this.addField((FieldEditor)timeoutEditor);
        processGroup.setLayout((Layout)new GridLayout(3, false));
        parent.setLayout((Layout)new FillLayout());
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(GraphvizLayouterPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        for (LayoutAlgorithmData data : LayoutDataService.getInstance().getAlgorithmData()) {
            if (!"de.cau.cs.kieler.kiml.categories.graphviz".equals(data.getCategory())) continue;
            data.getProviderPool().clear();
        }
        return super.performOk();
    }
}

