/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDegreeAnalysis
implements IAnalysis {
    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Node degree analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int numberOfNodes = 0;
        int overallNodeDegree = 0;
        int minNodeDegree = Integer.MAX_VALUE;
        int maxNodeDegree = 0;
        LinkedList nodeQueue = new LinkedList();
        numberOfNodes += parentNode.getChildren().size();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            int nodeDegree = 0;
            for (KEdge edge : node.getOutgoingEdges()) {
                if (edge.getTarget() == node || !hierarchy && edge.getTarget().getParent() != parentNode) continue;
                ++nodeDegree;
            }
            for (KEdge edge : node.getIncomingEdges()) {
                if (edge.getSource() == node || !hierarchy && edge.getSource().getParent() != parentNode) continue;
                ++nodeDegree;
            }
            if (nodeDegree < minNodeDegree) {
                minNodeDegree = nodeDegree;
            }
            if (nodeDegree > maxNodeDegree) {
                maxNodeDegree = nodeDegree;
            }
            overallNodeDegree += nodeDegree;
            if (!hierarchy) continue;
            numberOfNodes += node.getChildren().size();
            nodeQueue.addAll(node.getChildren());
        }
        progressMonitor.done();
        if (numberOfNodes > 0) {
            return new Object[]{minNodeDegree, Float.valueOf((float)overallNodeDegree / (float)numberOfNodes), maxNodeDegree};
        }
        return new Object[]{0, Float.valueOf(0.0f), 0};
    }
}

