/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.service;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.service.LayoutInfoService;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLayoutConfig
implements ILayoutConfig {
    public static final Property<Boolean> ACTIVATION = new Property("de.cau.cs.kieler.kiml.eclipse", (Object)true);
    public static final int PRIORITY = 10;
    public static final IProperty<IWorkbenchPart> WORKBENCH_PART = new Property("context.workbenchPart");
    public static final IProperty<Float> ASPECT_RATIO = new Property("context.aspectRatio");

    public static Object getValue(IProperty<?> property, Object diagramPart, EObject modelElement) {
        EClass eclazz;
        String clazzName;
        Object value;
        EclipseLayoutInfoService infoService = EclipseLayoutInfoService.getInstance();
        String id = property.getId();
        if (diagramPart != null && (value = infoService.getOptionValue(clazzName = diagramPart.getClass().getName(), id)) != null) {
            return value;
        }
        if (modelElement != null && (value = infoService.getOptionValue(eclazz = modelElement.eClass(), id)) != null) {
            return value;
        }
        return null;
    }

    public int getPriority() {
        return 10;
    }

    public void enrich(LayoutContext context) {
        Object diagPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        EObject domainElem = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        String diagramType = (String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT);
        if (diagramType == null) {
            diagramType = (String)EclipseLayoutConfig.getValue(LayoutOptions.DIAGRAM_TYPE, diagPart, domainElem);
            context.setProperty(DefaultLayoutConfig.CONTENT_DIAGT, (Object)diagramType);
        }
        if (((Boolean)context.getProperty(DefaultLayoutConfig.OPT_MAKE_OPTIONS)).booleanValue()) {
            String containerLayoutHint;
            String containerDiagramType;
            String layoutHint = (String)context.getProperty(DefaultLayoutConfig.CONTENT_HINT);
            if (layoutHint == null) {
                layoutHint = (String)EclipseLayoutConfig.getValue(LayoutOptions.ALGORITHM, diagPart, domainElem);
                if (layoutHint == null) {
                    layoutHint = (String)LayoutInfoService.getInstance().getOptionValue(diagramType, LayoutOptions.ALGORITHM.getId());
                }
                context.setProperty(DefaultLayoutConfig.CONTENT_HINT, (Object)layoutHint);
            }
            Object containerDiagPart = context.getProperty(LayoutContext.CONTAINER_DIAGRAM_PART);
            EObject containerDomainElem = (EObject)context.getProperty(LayoutContext.CONTAINER_DOMAIN_MODEL);
            if (containerDomainElem == null && containerDiagPart != null) {
                containerDomainElem = (EObject)EclipseLayoutInfoService.getInstance().getAdapter(containerDiagPart, EObject.class);
                context.setProperty(LayoutContext.CONTAINER_DOMAIN_MODEL, (Object)containerDomainElem);
            }
            if ((containerDiagramType = (String)context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT)) == null) {
                containerDiagramType = (String)EclipseLayoutConfig.getValue(LayoutOptions.DIAGRAM_TYPE, containerDiagPart, containerDomainElem);
                context.setProperty(DefaultLayoutConfig.CONTAINER_DIAGT, (Object)containerDiagramType);
            }
            if ((containerLayoutHint = (String)context.getProperty(DefaultLayoutConfig.CONTAINER_HINT)) == null) {
                containerLayoutHint = (String)EclipseLayoutConfig.getValue(LayoutOptions.ALGORITHM, containerDiagPart, containerDomainElem);
                if (containerLayoutHint == null) {
                    containerLayoutHint = (String)LayoutInfoService.getInstance().getOptionValue(containerDiagramType, LayoutOptions.ALGORITHM.getId());
                }
                context.setProperty(DefaultLayoutConfig.CONTAINER_HINT, (Object)containerLayoutHint);
            }
        }
    }

    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        EclipseLayoutInfoService infoService = EclipseLayoutInfoService.getInstance();
        Object result = null;
        result = EclipseLayoutConfig.getValue(optionData, context.getProperty(LayoutContext.DIAGRAM_PART), (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL));
        if (result != null) {
            return result;
        }
        if (optionData.getTargets().contains(LayoutOptionData.Target.PARENTS) ? (result = infoService.getOptionValue((String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT), optionData.getId())) != null : (result = infoService.getOptionValue((String)context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT), optionData.getId())) != null) {
            return result;
        }
        if (LayoutOptions.SIZE_CONSTRAINT.equals(optionData)) {
            return this.getSizeConstraintValue(context);
        }
        if (LayoutOptions.PORT_CONSTRAINTS.equals(optionData)) {
            return this.getPortConstraintsValue(context);
        }
        if (LayoutOptions.ASPECT_RATIO.equals(optionData)) {
            return this.getAspectRatioValue(context);
        }
        return null;
    }

    private SizeConstraint getSizeConstraintValue(LayoutContext context) {
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        if (targets != null && targets.contains(LayoutOptionData.Target.NODES)) {
            if (!targets.contains(LayoutOptionData.Target.PARENTS)) {
                return SizeConstraint.FIXED;
            }
            Boolean hasPorts = (Boolean)context.getProperty(DefaultLayoutConfig.HAS_PORTS);
            if (hasPorts != null && hasPorts.booleanValue()) {
                return SizeConstraint.MIN_PORTS;
            }
            return SizeConstraint.MIN_DEFAULT;
        }
        return null;
    }

    private PortConstraints getPortConstraintsValue(LayoutContext context) {
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        Boolean hasPorts = (Boolean)context.getProperty(DefaultLayoutConfig.HAS_PORTS);
        if (targets != null && targets.contains(LayoutOptionData.Target.NODES) && hasPorts != null) {
            if (!targets.contains(LayoutOptionData.Target.PARENTS) && hasPorts.booleanValue()) {
                return PortConstraints.FIXED_POS;
            }
            return PortConstraints.FREE;
        }
        return null;
    }

    private Float getAspectRatioValue(LayoutContext context) {
        Float aspectRatio = (Float)context.getProperty(ASPECT_RATIO);
        if (aspectRatio != null && aspectRatio.floatValue() > 0.0f) {
            return aspectRatio;
        }
        return null;
    }

    public void transferValues(KGraphData graphData, LayoutContext context) {
        LayoutOptionData optionData;
        EclipseLayoutInfoService infoService = EclipseLayoutInfoService.getInstance();
        LayoutDataService dataService = LayoutDataService.getInstance();
        Object value = this.getSizeConstraintValue(context);
        if (value != null) {
            graphData.setProperty(LayoutOptions.SIZE_CONSTRAINT, value);
        }
        if ((value = this.getPortConstraintsValue(context)) != null) {
            graphData.setProperty(LayoutOptions.PORT_CONSTRAINTS, value);
        }
        if ((value = this.getAspectRatioValue(context)) != null) {
            graphData.setProperty(LayoutOptions.ASPECT_RATIO, value);
        }
        Object diagPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        EObject modelElement = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        String diagramType = (String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT);
        if (diagramType != null) {
            for (Map.Entry entry : infoService.getOptionValues(diagramType).entrySet()) {
                if (entry.getValue() == null || (optionData = dataService.getOptionData((String)entry.getKey())) == null) continue;
                graphData.setProperty((IProperty)optionData, entry.getValue());
            }
        }
        if (modelElement != null) {
            for (Map.Entry entry : infoService.getOptionValues(modelElement.eClass()).entrySet()) {
                if (entry.getValue() == null || (optionData = dataService.getOptionData((String)entry.getKey())) == null) continue;
                graphData.setProperty((IProperty)optionData, entry.getValue());
            }
        }
        if (diagPart != null) {
            String clazzName = diagPart.getClass().getName();
            for (Map.Entry entry : infoService.getOptionValues(clazzName).entrySet()) {
                LayoutOptionData optionData2;
                if (entry.getValue() == null || (optionData2 = dataService.getOptionData((String)entry.getKey())) == null) continue;
                graphData.setProperty((IProperty)optionData2, entry.getValue());
            }
        }
    }
}

