/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui;

import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.ui.service.EclipseAnalysisService;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutDataService;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.service.EclipseTransformationService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class KimlUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.cau.cs.kieler.kiml.ui";
    private static KimlUiPlugin plugin;
    private Images images;

    public Images getImages() {
        return this.images;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.images = new Images();
        EclipseLayoutDataService.create();
        EclipseLayoutInfoService.create();
        EclipseTransformationService.create();
        EclipseAnalysisService.create();
        LayoutDataService.setMode((String)"de.cau.cs.kieler.kiml.ui.service.EclipseLayoutDataService");
    }

    public void stop(BundleContext context) throws Exception {
        EclipseLayoutInfoService layoutInfoService = EclipseLayoutInfoService.getInstance();
        if (layoutInfoService != null) {
            layoutInfoService.storePreferences();
        }
        LayoutDataService layoutDataService = LayoutDataService.getInstance();
        for (LayoutAlgorithmData algoData : layoutDataService.getAlgorithmData()) {
            algoData.getProviderPool().clear();
        }
        plugin = null;
        if (this.images != null) {
            this.images.dispose();
            this.images = null;
        }
        super.stop(context);
    }

    public static KimlUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return KimlUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static class Images {
        private final Image propChoice = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_choice.gif").createImage();
        private final Image propFalse = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_false.gif").createImage();
        private final Image propFloat = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_float.gif").createImage();
        private final Image propInt = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_int.gif").createImage();
        private final Image propText = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_text.gif").createImage();
        private final Image propTrue = KimlUiPlugin.getImageDescriptor("icons/obj16/prop_true.gif").createImage();

        Images() {
        }

        void dispose() {
            this.getPropChoice().dispose();
            this.getPropFalse().dispose();
            this.getPropFloat().dispose();
            this.getPropInt().dispose();
            this.getPropText().dispose();
            this.getPropTrue().dispose();
        }

        public Image getPropChoice() {
            return this.propChoice;
        }

        public Image getPropFalse() {
            return this.propFalse;
        }

        public Image getPropFloat() {
            return this.propFloat;
        }

        public Image getPropInt() {
            return this.propInt;
        }

        public Image getPropText() {
            return this.propText;
        }

        public Image getPropTrue() {
            return this.propTrue;
        }
    }
}

