/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.room.util.RoomSwitch;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

public class StaticResourceHelpers {
    public static final QualifiedName ANNOTATION_FQN_USES_RESOURCE = QualifiedName.create((String[])new String[]{"etrice", "api", "annotations", "UsesResource"});
    public static final String TYPE_IMPLICIT = "implicit";
    private static final Pattern PATTERN_USER_DATA = Pattern.compile("(?:^|,)" + ANNOTATION_FQN_USES_RESOURCE.toString().replace(".", "\\.") + ":");
    @Inject
    RoomHelpers roomHelpers;
    @Inject
    IQualifiedNameProvider qualifiedNames;

    public Stream<Annotation> getTransitiveResourcesOfType(ActorContainerClass container, String type) {
        Collection<? extends ActorContainerClass> acList = this.getContainerHierarchy(container);
        return acList.stream().flatMap(ac -> this.getResourcesOfType((ActorContainerClass)ac, type));
    }

    public Stream<Annotation> getResourcesOfType(ActorContainerClass container, String type) {
        if (container == null) {
            return Stream.empty();
        }
        return this.roomHelpers.getAnnotations(container).stream().filter(annotation -> {
            AnnotationType annotationType = annotation.getType();
            return annotationType != null && !annotationType.eIsProxy() && this.qualifiedNames.getFullyQualifiedName((EObject)annotationType).equals((Object)ANNOTATION_FQN_USES_RESOURCE);
        }).filter(annotation -> this.isAttributeValid((Annotation)annotation, type));
    }

    public boolean hasUsesResourceAnnotation(IEObjectDescription description) {
        String annotationUserData = description.getUserData("ROOM_ANNOTATIONS");
        return annotationUserData != null && PATTERN_USER_DATA.matcher(annotationUserData).find();
    }

    private Collection<? extends ActorContainerClass> getContainerHierarchy(ActorContainerClass container) {
        RoomSwitch<Collection<? extends ActorContainerClass>> hierarchySwitch = new RoomSwitch<Collection<? extends ActorContainerClass>>(){

            @Override
            public Collection<? extends ActorContainerClass> caseActorClass(ActorClass object) {
                if (object.getActorBase() == null) {
                    return Collections.singletonList(object);
                }
                return StaticResourceHelpers.this.roomHelpers.getClassHierarchy(object);
            }

            @Override
            public List<? extends ActorContainerClass> caseActorContainerClass(ActorContainerClass object) {
                return Collections.singletonList(object);
            }
        };
        return (Collection)hierarchySwitch.doSwitch(container);
    }

    private boolean isAttributeValid(Annotation annotation, String attributeName) {
        for (KeyValue attr : annotation.getAttributes()) {
            if (attr.getKey() == null || !attr.getKey().equals(attributeName) || attr.getValue() == null || attr.getValue().eIsProxy()) continue;
            return true;
        }
        return false;
    }
}

