/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.args;

import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.args.Options;

public class Arguments {
    private Options options;
    private HashMap<String, Object> option2Arg;

    public Arguments(Options options) {
        this.options = options;
        this.option2Arg = new HashMap();
        for (Option<?> option : options) {
            this.option2Arg.put(option.getName(), option.getDefaultValue());
        }
    }

    public Object get(String name) throws IllegalArgumentException {
        Object value = this.option2Arg.get(name);
        if (value == null) {
            throw new IllegalArgumentException("option " + name + " not recognized");
        }
        return value;
    }

    public <T> T get(Option<T> option) throws IllegalArgumentException {
        return option.getType().cast(this.get(option.getName()));
    }

    public void set(String name, Object value) throws IllegalArgumentException {
        Option<?> opt = this.options.get(name);
        if (!opt.getType().isInstance(value)) {
            throw new IllegalArgumentException("value " + value.toString() + " is not assignable to Option " + opt.toString());
        }
        this.option2Arg.put(name, value);
    }

    public <T> void set(Option<T> option, T value) throws IllegalArgumentException {
        this.set(option.getName(), value);
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Option<?> opt : this.options) {
            joiner.add(this.argToString(opt));
        }
        return joiner.toString();
    }

    private String argToString(Option<?> opt) {
        String result = opt.getName() + "=";
        Object obj = this.option2Arg.get(opt.getName());
        if (opt.getType().isArray()) {
            Object[] objArr = (Object[])obj;
            result = result + Arrays.toString(objArr);
        } else {
            result = result + obj.toString();
        }
        return result;
    }
}

