/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.ast;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.dctools.fsm.ast.CandidateMap;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstArrayAccessNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstFeatureCallNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstIdentifierNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstOperationCallNode;
import org.eclipse.etrice.dctools.fsm.ast.util.IDCAstNodeVisitor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DCLinker
implements IDCAstNodeVisitor {
    private EObject owner;
    private EReference reference;
    private MessageData transitionData;
    @Extension
    protected final RoomHelpers roomHelpers = new RoomHelpers();
    private final Deque<EObject> contexts = new LinkedList<EObject>();

    public DCLinker(DetailCode dc) {
        this(dc.eContainer(), (EReference)dc.eContainingFeature());
    }

    public DCLinker(EObject owner, EReference reference) {
        this(owner, reference, null);
    }

    public DCLinker(DetailCode dc, MessageData transitionData) {
        this(dc.eContainer(), (EReference)dc.eContainingFeature(), transitionData);
    }

    public DCLinker(EObject owner, EReference reference, MessageData transitionData) {
        this.owner = owner;
        this.reference = reference;
        this.transitionData = transitionData;
    }

    public boolean visitBegin(DCAstNode node) {
        DCAstNode dCAstNode;
        boolean bl = false;
        if (node instanceof DCAstFeatureCallNode) {
            bl = true;
            this.contexts.push(this.owner);
        }
        if (!bl && node instanceof DCAstIdentifierNode && (dCAstNode = ((DCAstIdentifierNode)node).getParent()) instanceof DCAstFeatureCallNode) {
            bl = true;
            this.link(node);
        }
        if (!bl && node instanceof DCAstArrayAccessNode) {
            bl = true;
            this.link(node);
        }
        if (!bl && node instanceof DCAstOperationCallNode) {
            bl = true;
            this.link(node);
        }
        return true;
    }

    public void visitEnd(DCAstNode node) {
        if (node instanceof DCAstFeatureCallNode) {
            this.contexts.pop();
        }
    }

    protected void _link(DCAstIdentifierNode node) {
        this.doLink((DCAstNode)node, FeatureType.SCALAR, node.getId());
    }

    protected void _link(DCAstArrayAccessNode node) {
        this.doLink((DCAstNode)node, FeatureType.ARRAY, node.id());
    }

    protected void _link(DCAstOperationCallNode node) {
        this.doLink((DCAstNode)node, FeatureType.OPERATION, node.id());
    }

    protected void doLink(DCAstNode node, FeatureType ft, String name) {
        CandidateMap candidates = this.getCandidates(ft);
        node.setLinkedObject((EObject)candidates.get((Object)name));
        node.setLinkedData((Object)candidates);
        this.replaceContext(node.getLinkedObject());
    }

    protected void replaceContext(EObject obj) {
        this.contexts.pop();
        RoomElement roomElement = null;
        if (obj != null) {
            roomElement = this.getContextOf(obj);
        }
        this.contexts.push((EObject)roomElement);
    }

    protected RoomElement _getContextOf(EObject obj) {
        return null;
    }

    protected RoomElement _getContextOf(Port port) {
        return port;
    }

    protected RoomElement _getContextOf(Attribute att) {
        return att.getType().getType();
    }

    protected RoomElement _getContextOf(VarDecl vd) {
        return vd.getRefType().getType();
    }

    protected RoomElement _getContextOf(MessageData md) {
        RefableType refableType = null;
        if (md != null) {
            refableType = md.getRefType();
        }
        DataType dataType = null;
        if (refableType != null) {
            dataType = refableType.getType();
        }
        return dataType;
    }

    protected RoomElement _getContextOf(Operation op) {
        RefableType refableType = null;
        if (op != null) {
            refableType = op.getReturnType();
        }
        DataType dataType = null;
        if (refableType != null) {
            dataType = refableType.getType();
        }
        return dataType;
    }

    protected CandidateMap getCandidates(FeatureType type) {
        boolean bl;
        CandidateMap candidates = new CandidateMap();
        EObject eObject = this.contexts.peek();
        boolean bl2 = bl = eObject == this.owner;
        if (bl) {
            this.topLevelCandidates(candidates, type);
        } else {
            DataClass dc;
            Object object;
            DataType dataType;
            RefableType refableType;
            EObject current = this.contexts.peek();
            boolean bl3 = false;
            if (current instanceof DataClass) {
                bl3 = true;
                this.getCandidates((DataClass)current, type, candidates);
            }
            if (!bl3 && current instanceof InterfaceItem) {
                bl3 = true;
                this.getCandidates((InterfaceItem)current, candidates);
            }
            if (!bl3 && current instanceof Attribute) {
                refableType = ((Attribute)current).getType();
                dataType = null;
                if (refableType != null) {
                    dataType = refableType.getType();
                }
                if (dataType instanceof DataClass) {
                    bl3 = true;
                    object = ((Attribute)current).getType().getType();
                    dc = (DataClass)object;
                    this.getCandidates(dc, type, candidates);
                }
            }
            if (!bl3 && current instanceof MessageData) {
                refableType = ((MessageData)current).getRefType();
                dataType = null;
                if (refableType != null) {
                    dataType = refableType.getType();
                }
                if (dataType instanceof DataClass) {
                    bl3 = true;
                    object = ((MessageData)current).getRefType().getType();
                    dc = (DataClass)object;
                    this.getCandidates(dc, type, candidates);
                }
            }
            if (!bl3 && current instanceof EnumerationType) {
                EObject resolved;
                bl3 = true;
                EnumerationType enumType = (EnumerationType)current;
                boolean bl4 = ((EnumerationType)current).eIsProxy();
                if (bl4 && (resolved = EcoreUtil.resolve((EObject)current, (EObject)this.owner)) instanceof EnumerationType) {
                    enumType = (EnumerationType)resolved;
                }
                object = it -> candidates.put((Object)it.getName(), it);
                enumType.getLiterals().forEach((Consumer)object);
            }
        }
        return candidates;
    }

    protected void topLevelCandidates(CandidateMap candidates, FeatureType type) {
        boolean bl;
        boolean bl2;
        Operation operation = (Operation)EcoreUtil2.getContainerOfType((EObject)this.owner, Operation.class);
        EList eList = null;
        if (operation != null) {
            eList = operation.getArguments();
        }
        if (eList != null) {
            Consumer<VarDecl> consumer = it -> candidates.put((Object)it.getName(), it);
            eList.forEach(consumer);
        }
        boolean bl3 = bl2 = !(bl = this.reference.getName().contains("userCode"));
        if (bl2) {
            Consumer<Attribute> consumer;
            boolean bl4;
            RoomClass roomClass = (RoomClass)EcoreUtil2.getContainerOfType((EObject)this.owner, RoomClass.class);
            boolean bl5 = false;
            if (roomClass instanceof ActorClass) {
                boolean bl6;
                boolean bl7;
                bl5 = true;
                if (this.transitionData != null) {
                    candidates.put((Object)"transitionData", (Object)this.transitionData);
                }
                if (bl7 = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.SCALAR))) {
                    Consumer<Attribute> consumer2 = it -> candidates.put((Object)it.getName(), it);
                    this.roomHelpers.getAllAttributes((ActorClass)roomClass).forEach(consumer2);
                }
                if (bl4 = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.ARRAY))) {
                    Functions.Function1 function1 = it -> {
                        int n = it.getSize();
                        return n > 1;
                    };
                    consumer = it -> candidates.put((Object)it.getName(), it);
                    IterableExtensions.filter((Iterable)this.roomHelpers.getAllAttributes((ActorClass)roomClass), (Functions.Function1)function1).forEach(consumer);
                }
                if (bl6 = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.OPERATION))) {
                    consumer = it -> candidates.put((Object)it.getName(), it);
                    this.roomHelpers.getLatestOperations((ActorClass)roomClass).forEach(consumer);
                }
                consumer = it -> {
                    boolean bl;
                    boolean bl2 = false;
                    if (it instanceof Port && (bl = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.SCALAR)))) {
                        bl2 = true;
                        candidates.put((Object)((Port)it).getName(), it);
                    }
                    if (!bl2 && it instanceof Port && com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.ARRAY)) && ((Port)it).isReplicated()) {
                        bl2 = true;
                        candidates.put((Object)((Port)it).getName(), it);
                    }
                    if (!bl2 && it instanceof SAP && (bl = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.SCALAR)))) {
                        bl2 = true;
                        candidates.put((Object)((SAP)it).getName(), it);
                    }
                };
                this.roomHelpers.getAllInterfaceItems((ActorClass)roomClass).forEach(consumer);
            }
            if (!bl5 && roomClass instanceof DataClass) {
                bl5 = true;
                this.getCandidates((DataClass)roomClass, type, candidates);
            }
            if (!bl5) {
                PortClass portClass = (PortClass)EcoreUtil2.getContainerOfType((EObject)this.owner, PortClass.class);
                boolean bl8 = bl4 = portClass != null;
                if (bl4) {
                    bl5 = true;
                    PortClass portClass2 = (PortClass)EcoreUtil2.getContainerOfType((EObject)this.owner, PortClass.class);
                    consumer = it -> candidates.put((Object)it.getName(), it);
                    portClass2.getOperations().forEach(consumer);
                    Consumer<Attribute> consumer3 = it -> candidates.put((Object)it.getName(), it);
                    portClass2.getAttributes().forEach(consumer3);
                }
            }
        }
    }

    protected void getCandidates(DataClass dataClass, FeatureType type, CandidateMap candidates) {
        boolean bl;
        Consumer<Attribute> consumer;
        boolean bl2;
        boolean bl3 = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.SCALAR));
        if (bl3) {
            Consumer<Attribute> consumer2 = it -> candidates.put((Object)it.getName(), it);
            this.roomHelpers.getAllAttributes(dataClass).forEach(consumer2);
        }
        if (bl2 = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.ARRAY))) {
            Functions.Function1 function1 = it -> {
                int n = it.getSize();
                return n > 1;
            };
            consumer = it -> candidates.put((Object)it.getName(), it);
            IterableExtensions.filter((Iterable)this.roomHelpers.getAllAttributes(dataClass), (Functions.Function1)function1).forEach(consumer);
        }
        if (bl = com.google.common.base.Objects.equal((Object)((Object)type), (Object)((Object)FeatureType.OPERATION))) {
            consumer = it -> candidates.put((Object)it.getName(), it);
            this.roomHelpers.getLatestOperations(dataClass).forEach(consumer);
        }
    }

    protected void getCandidates(InterfaceItem ifItem, CandidateMap candidates) {
        Consumer<Message> consumer;
        ProtocolClass protocolClass = ifItem.getProtocol();
        boolean bl = this.roomHelpers.isConjugated(ifItem);
        boolean bl2 = !bl;
        Consumer<PortOperation> consumer2 = it -> candidates.put((Object)it.getName(), it);
        this.roomHelpers.getAllOperations(protocolClass, bl2).forEach(consumer2);
        EReference reference = this.reference;
        boolean bl3 = false;
        if (Objects.equals(reference, FSMPackage.Literals.CP_BRANCH_TRANSITION__CONDITION)) {
            bl3 = true;
        }
        if (!bl3 && Objects.equals(reference, FSMPackage.Literals.GUARDED_TRANSITION__GUARD)) {
            bl3 = true;
        }
        if (!bl3 && Objects.equals(reference, FSMPackage.Literals.GUARD__GUARD)) {
            bl3 = true;
        }
        if (bl3) {
            ProtocolClass pc = ifItem.getProtocol();
            CommunicationType communicationType = null;
            if (pc != null) {
                communicationType = pc.getCommType();
            }
            if (communicationType != null) {
                switch (communicationType) {
                    case DATA_DRIVEN: {
                        boolean bl4;
                        boolean bl5 = this.roomHelpers.isConjugated(ifItem);
                        boolean bl6 = bl4 = !bl5;
                        if (!bl4) break;
                        consumer = it -> candidates.put((Object)it.getName(), it);
                        this.roomHelpers.getAllIncomingMessages(pc).forEach(consumer);
                        break;
                    }
                    case EVENT_DRIVEN: {
                        break;
                    }
                    case SYNCHRONOUS: {
                        break;
                    }
                }
            }
        }
        if (!bl3) {
            boolean bl7;
            StateGraphItem stateGraphItem = (StateGraphItem)EcoreUtil2.getContainerOfType((EObject)this.owner, StateGraphItem.class);
            boolean bl8 = bl7 = stateGraphItem != null;
            if (bl7) {
                bl3 = true;
                ProtocolClass pc_1 = ifItem.getProtocol();
                CommunicationType communicationType = null;
                if (pc_1 != null) {
                    communicationType = pc_1.getCommType();
                }
                if (communicationType != null) {
                    switch (communicationType) {
                        case EVENT_DRIVEN: {
                            consumer = it -> candidates.put((Object)it.getName(), it);
                            this.roomHelpers.getAllMessages(pc_1, this.roomHelpers.isConjugated(ifItem)).forEach(consumer);
                            break;
                        }
                        case DATA_DRIVEN: {
                            Consumer<Message> consumer3 = it -> candidates.put((Object)it.getName(), it);
                            this.roomHelpers.getAllIncomingMessages(pc_1).forEach(consumer3);
                            break;
                        }
                        case SYNCHRONOUS: {
                            break;
                        }
                    }
                }
            }
        }
    }

    protected void link(DCAstNode node) {
        if (node instanceof DCAstArrayAccessNode) {
            this._link((DCAstArrayAccessNode)node);
            return;
        }
        if (node instanceof DCAstIdentifierNode) {
            this._link((DCAstIdentifierNode)node);
            return;
        }
        if (node instanceof DCAstOperationCallNode) {
            this._link((DCAstOperationCallNode)node);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    protected RoomElement getContextOf(EObject port) {
        if (port instanceof Port) {
            return this._getContextOf((Port)port);
        }
        if (port instanceof Attribute) {
            return this._getContextOf((Attribute)port);
        }
        if (port instanceof MessageData) {
            return this._getContextOf((MessageData)port);
        }
        if (port instanceof Operation) {
            return this._getContextOf((Operation)port);
        }
        if (port instanceof VarDecl) {
            return this._getContextOf((VarDecl)port);
        }
        if (port != null) {
            return this._getContextOf(port);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port).toString());
    }

    public static enum FeatureType {
        SCALAR,
        ARRAY,
        OPERATION;

    }
}

