/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.editor.RoomEditor;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.etrice.ui.common.commands.ChangeDiagramInputJob;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;

public class BehaviorEditor
extends AbstractFSMEditor {
    public static final String BEHAVIOR_EDITOR_ID = "org.eclipse.etrice.ui.behavior.editor.BehaviorEditor";
    private boolean showLostDiagramInputDialog = true;

    public BehaviorEditor() {
        super(RoomEditor.class);
    }

    public Image getDefaultImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    public ActorClass getActorClass() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
        if (bo instanceof ActorClass) {
            return (ActorClass)bo;
        }
        return null;
    }

    protected StructureClass getStructureClass() {
        return (StructureClass)this.getModelComponent();
    }

    protected void handleMissingDiagramBo(Diagram diagram) {
        if (!this.showLostDiagramInputDialog) {
            return;
        }
        this.showLostDiagramInputDialog = false;
        MessageDialog dialog = new MessageDialog(this.getGraphicalControl().getShell(), "Diagram out-dated", null, "Diagram input lost. Cannot find ROOM file or class for " + diagram.getName() + "\n\n" + "Please ensure that no whitespace or special characters are contained in any related path, file or project", 1, new String[]{"OK", "Reconnect Diagram"}, 0);
        int result = dialog.open();
        if (result == 1) {
            new ChangeDiagramInputJob("Change input for " + diagram.getName(), (DiagramEditorBase)this).schedule();
        }
    }

    public EObject getModel() {
        return this.getActorClass().eContainer();
    }
}

