/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.abstractexec.behavior.ProposalGenerator;
import org.eclipse.etrice.abstractexec.behavior.SemanticsCheck;
import org.eclipse.etrice.core.common.validation.ICustomValidator;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class AbstractExecutionValidator
implements ICustomValidator {
    public static final String DIAG_CODE_VIOLATION_TRIGGER = "etrice.violation_trigger";
    public static final String DIAG_CODE_VIOLATION_MESSAGESEND = "etrice.violation_messagesend";
    public static final String DIAG_CODE_MISSING_TRIGGER = "etrice.receive_message";
    public static final String DIAG_CODE_MISSING_MESSAGESEND = "etrice.send_message";
    @Inject
    private FSMHelpers fsmHelpers;
    @Inject
    private ExtendedFsmGenBuilderFactory fsmGenBuilderFactory;
    private static final Set<EClass> classesToCheck = new HashSet<EClass>();
    private static boolean traceExec = false;
    private static String traceName = "";
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();

    static {
        classesToCheck.add(FSMPackage.Literals.MODEL_COMPONENT);
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/abstractexec");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceExec = true;
            }
            traceName = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/abstractexec/name");
        }
    }

    public void validate(EObject object, ValidationMessageAcceptor messageAcceptor, ICustomValidator.ValidationContext context) {
        if (!(object instanceof ModelComponent)) {
            return;
        }
        if (context.isGeneration()) {
            return;
        }
        ModelComponent mc = (ModelComponent)object;
        if (traceExec) {
            if (!traceName.isEmpty() && !mc.getComponentName().equals(traceName)) {
                return;
            }
            System.out.println("AbstractExecutionValidator checking class " + mc.getComponentName());
        }
        if (mc.isAbstract()) {
            return;
        }
        if (this.fsmHelpers.isCircularClassHierarchy(mc)) {
            return;
        }
        boolean oneProtocolsWithSemantics = false;
        EList ifItems = mc.getAllAbstractInterfaceItems();
        for (AbstractInterfaceItem item : ifItems) {
            if (item.getSemantics() == null) continue;
            oneProtocolsWithSemantics = true;
            if (!traceExec) break;
            System.out.println("  Will execute because semantics defined for interface item " + item.getName());
            break;
        }
        if (oneProtocolsWithSemantics) {
            GraphContainer gc;
            if (traceExec) {
                System.out.println("  Reached where at least one interface items has semantics");
            }
            NullDiagnostician diagnostician = new NullDiagnostician();
            ExtendedFsmGenBuilder builder = this.fsmGenBuilderFactory.create((IDiagnostician)diagnostician);
            try {
                gc = builder.createTransformedModel(mc);
                builder.withTriggersInStates(gc);
            }
            catch (Throwable throwable) {
                return;
            }
            if (gc != null && gc.getGraph() != null && !diagnostician.isFailed()) {
                SemanticsCheck checker = new SemanticsCheck(gc);
                checker.checkSemantics();
                if (traceExec) {
                    System.out.println("  Rule checking for " + mc.getComponentName() + " is over");
                }
                for (Node node : IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllNodes((Graph)gc.getGraph()))) {
                    if (!(node.getStateGraphNode() instanceof State)) continue;
                    ProposalGenerator propGen = new ProposalGenerator(checker);
                    propGen.createProposals(node);
                    this.createMarkersForProposals(propGen, messageAcceptor, node, gc);
                }
                for (Link link : IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllLinks((Graph)gc.getGraph()))) {
                    this.createMarkersForWarnings(checker, messageAcceptor, (GraphItem)link, gc);
                }
                if (traceExec) {
                    System.out.println("AbstractExecutionValidator done checking class " + mc.getComponentName());
                }
            } else if (traceExec) {
                System.out.println("No checking because internal generation failed");
            }
        }
    }

    public String getName() {
        return "Abstract FSM Execution Validator";
    }

    public String getDescription() {
        return "This validator checks the state machine against the protocol semantics of its ports.";
    }

    public Set<EClass> getClassesToCheck() {
        return classesToCheck;
    }

    private void createMarkersForProposals(ProposalGenerator propGen, ValidationMessageAcceptor messageAcceptor, Node node, GraphContainer gc) {
        List<MessageFromIf> incoming = propGen.getIncomingProposals();
        String name = FsmGenExtensions.getName((GraphItem)node);
        StateGraphNode orig = node.getStateGraphNode();
        EObject container = orig.eContainer();
        int idx = ((List)container.eGet(orig.eContainingFeature())).indexOf(orig);
        for (MessageFromIf msg : incoming) {
            messageAcceptor.acceptWarning("State should handle the message " + this.fsmNameProvider.getMessageName(msg.getMessage()) + " from port " + msg.getFrom().getName() + " ", container, orig.eContainingFeature(), idx, DIAG_CODE_MISSING_TRIGGER, new String[]{name, this.fsmNameProvider.getMessageName(msg.getMessage()), msg.getFrom().getName()});
        }
        List<MessageFromIf> outgoing = propGen.getOutgoingProposals();
        for (MessageFromIf msg : outgoing) {
            messageAcceptor.acceptInfo("State should send the message " + this.fsmNameProvider.getMessageName(msg.getMessage()) + " to port " + msg.getFrom().getName() + " ", container, orig.eContainingFeature(), idx, DIAG_CODE_MISSING_MESSAGESEND, new String[]{name, this.fsmNameProvider.getMessageName(msg.getMessage()), msg.getFrom().getName()});
        }
    }

    private void createMarkersForWarnings(SemanticsCheck checker, ValidationMessageAcceptor messageAcceptor, GraphItem item, GraphContainer gc) {
        List<HandledMessage> warningList = checker.getWarningMsg(item);
        if (traceExec && warningList != null) {
            String name = FsmGenExtensions.getName((GraphItem)item);
            System.out.println("Messages in the warning list for item " + name);
        }
        if (warningList != null) {
            for (HandledMessage msg : warningList) {
                EObject origin = msg.getOrigin();
                if (origin instanceof CommonTrigger) {
                    CommonTrigger trigger = (CommonTrigger)origin;
                    for (Link trans : trigger.getLinks()) {
                        TriggeredTransition orig = (TriggeredTransition)trans.getTransition();
                        for (Trigger trig : orig.getTriggers()) {
                            for (MessageFromIf mif : trig.getMsgFromIfPairs()) {
                                if (mif.getMessage() != msg.getMsg() || mif.getFrom() != msg.getIfitem()) continue;
                                String txt = "The message violates the semantic rule";
                                if (msg.getReason() != null) {
                                    txt = String.valueOf(txt) + "\n" + msg.getReason();
                                }
                                messageAcceptor.acceptWarning(txt, (EObject)trig, mif.eContainingFeature(), trig.getMsgFromIfPairs().indexOf((Object)mif), DIAG_CODE_VIOLATION_TRIGGER, new String[]{this.fsmNameProvider.getMessageName(trigger.getMsg()), this.fsmNameProvider.getMessageName(mif.getMessage()), mif.getFrom().getName()});
                            }
                        }
                    }
                    continue;
                }
                if (!(origin instanceof DetailCode)) continue;
                DetailCode dc = (DetailCode)origin;
                String txt = "The message violates the semantic rule";
                if (msg.getReason() != null) {
                    txt = String.valueOf(txt) + "\n" + msg.getReason();
                }
                messageAcceptor.acceptWarning(txt, dc.eContainer(), dc.eContainingFeature(), -1, DIAG_CODE_VIOLATION_MESSAGESEND, new String[]{this.fsmNameProvider.getMessageName(msg.getMsg()), msg.getIfitem().getName()});
            }
        }
    }
}

