/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.editor;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.base.export.DiagramExporter;
import org.eclipse.etrice.ui.common.base.export.IBulkDiagramExporter;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.etrice.ui.structure.DiagramAccess;

public class StructureExporter
implements IBulkDiagramExporter {
    private static final String SUFFIX = "_structure";

    public void export(EObject roomClass, String folder) {
        Assert.isLegal((boolean)(roomClass instanceof StructureClass));
        StructureClass sc = (StructureClass)roomClass;
        File exportFile = new File(folder, String.valueOf(this.getQualifiedBaseName(sc)) + SUFFIX);
        DiagramAccess da = new DiagramAccess();
        DiagramExporter.export((EObject)sc, (DiagramAccessBase)da, (String)exportFile.toString());
    }

    private String getQualifiedBaseName(StructureClass sc) {
        String namespace = "";
        if (sc.eContainer() instanceof RoomModel) {
            namespace = String.valueOf(((RoomModel)sc.eContainer()).getName()) + ".";
        }
        String filename = String.valueOf(namespace) + sc.getName();
        return filename;
    }
}

