/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.dialogs;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IMemberAwareConfiguration;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.StringToDetailCode;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.dialogs.AbstractPropertyDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TransitionTriggerCompartment {
    private AbstractPropertyDialog parent;
    private Transition trans;
    private List<AbstractInterfaceItem> interfaceItems;
    private boolean inherited;
    private TableViewer triggerViewer;
    private TableViewer mifViewer;
    private Combo messageCombo;
    private Combo interfaceCombo;
    private Button removeMifButton;
    private List<EObject> currentMsgs;
    private Text guardText;
    private DetailCodeToString m2s;
    private StringToDetailCode s2m;
    private IMemberAwareConfiguration memberAwareConfiguration;
    private FSMNameProvider nameProvider = new FSMNameProvider();

    public TransitionTriggerCompartment(AbstractPropertyDialog parent, Transition trans, List<AbstractInterfaceItem> interfaceItems, boolean inherited, IMemberAwareConfiguration memberAwareConfiguration) {
        this.parent = parent;
        this.trans = trans;
        this.interfaceItems = interfaceItems;
        this.inherited = inherited;
        this.memberAwareConfiguration = memberAwareConfiguration;
        this.m2s = new DetailCodeToString();
        this.s2m = new StringToDetailCode();
    }

    public boolean triggersAvailable() {
        if (this.interfaceItems.isEmpty()) {
            return false;
        }
        for (AbstractInterfaceItem item : this.interfaceItems) {
            if (item.getAllIncomingAbstractMessages().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void createTriggerCompartment(Composite body, FormToolkit toolkit) {
        Label l = toolkit.createLabel(body, "Triggers:", 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        if (this.triggersAvailable()) {
            this.createTriggerCompartmentInternal(body, toolkit);
        } else {
            Label error = toolkit.createLabel(body, "No triggers available (no incoming messages).", 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            error.setLayoutData((Object)gd);
        }
    }

    private void createTriggerCompartmentInternal(Composite body, FormToolkit toolkit) {
        Composite triggerCompartment = toolkit.createComposite(body);
        triggerCompartment.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        triggerCompartment.setLayoutData((Object)gd);
        this.createTriggerTable(triggerCompartment, toolkit);
        this.createMifTable(triggerCompartment, toolkit);
        this.createMifCompartment(triggerCompartment, toolkit);
        if (this.inherited) {
            this.disableAll(triggerCompartment);
        }
        this.addListeners();
        this.triggerViewer.setSelection((ISelection)new StructuredSelection(((TriggeredTransition)this.trans).getTriggers().get(0)), true);
    }

    private void createTriggerTable(Composite triggerCompartment, FormToolkit toolkit) {
        Composite tableCompartment = toolkit.createComposite(triggerCompartment);
        tableCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        tableCompartment.setLayoutData((Object)gd);
        Table triggerTable = toolkit.createTable(tableCompartment, 2052);
        gd = new GridData(768);
        gd.heightHint = 50;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        triggerTable.setLayoutData((Object)gd);
        this.triggerViewer = new TableViewer(triggerTable);
        this.triggerViewer.setContentProvider((IContentProvider)new TriggerContentProvider());
        this.triggerViewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider());
        this.triggerViewer.setInput((Object)this.trans);
        this.memberAwareConfiguration.configureMemberAwareness((Control)triggerTable);
        if (((TriggeredTransition)this.trans).getTriggers().isEmpty()) {
            this.addNewTrigger();
        }
        Button add = toolkit.createButton(tableCompartment, "Add", 0);
        gd = new GridData(768);
        add.setLayoutData((Object)gd);
        this.memberAwareConfiguration.configureMemberAwareness((Control)add);
        final Button remove = toolkit.createButton(tableCompartment, "Remove", 0);
        gd = new GridData(768);
        remove.setLayoutData((Object)gd);
        if (((TriggeredTransition)this.trans).getTriggers().size() == 1) {
            remove.setEnabled(false);
        }
        this.memberAwareConfiguration.configureMemberAwareness((Control)remove);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.addNewTrigger();
                remove.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.removeCurrentTrigger();
                if (((TriggeredTransition)TransitionTriggerCompartment.this.trans).getTriggers().size() == 1) {
                    remove.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createMifTable(Composite triggerCompartment, FormToolkit toolkit) {
        Composite tableCompartment = toolkit.createComposite(triggerCompartment);
        tableCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        tableCompartment.setLayoutData((Object)gd);
        Table mifTable = toolkit.createTable(tableCompartment, 2052);
        gd = new GridData(768);
        gd.heightHint = 50;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        mifTable.setLayoutData((Object)gd);
        this.mifViewer = new TableViewer(mifTable);
        this.mifViewer.setContentProvider((IContentProvider)new MessageFromInterfaceContentProvider());
        this.mifViewer.setLabelProvider((IBaseLabelProvider)new MessageFromInterfaceLabelProvider());
        this.memberAwareConfiguration.configureMemberAwareness((Control)mifTable);
        Button add = toolkit.createButton(tableCompartment, "Add", 0);
        gd = new GridData(768);
        add.setLayoutData((Object)gd);
        this.memberAwareConfiguration.configureMemberAwareness((Control)add);
        this.removeMifButton = toolkit.createButton(tableCompartment, "Remove", 0);
        gd = new GridData(768);
        this.removeMifButton.setLayoutData((Object)gd);
        this.memberAwareConfiguration.configureMemberAwareness((Control)this.removeMifButton);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.addNewMif();
                TransitionTriggerCompartment.this.removeMifButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeMifButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.removeCurrentMif();
                TransitionTriggerCompartment.this.updateMifButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updateMifButton() {
        this.removeMifButton.setEnabled(this.mifViewer.getTable().getItemCount() > 1);
    }

    private void createMifCompartment(Composite triggerCompartment, FormToolkit toolkit) {
        Composite mifCompartment = toolkit.createComposite(triggerCompartment);
        mifCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        mifCompartment.setLayoutData((Object)gd);
        this.createInterfaceCombo(mifCompartment, toolkit);
        this.createMessageCombo(mifCompartment, toolkit);
        Label l = toolkit.createLabel(mifCompartment, "Guard:", 0);
        l.setLayoutData((Object)new GridData());
        this.guardText = toolkit.createText(mifCompartment, "", 2050);
        this.memberAwareConfiguration.configureMemberAwareness((Control)this.guardText, true, true, true);
        gd = new GridData(768);
        gd.heightHint = 50;
        this.guardText.setLayoutData((Object)gd);
    }

    private void createInterfaceCombo(Composite triggerCompartment, FormToolkit toolkit) {
        Label l = toolkit.createLabel(triggerCompartment, "Interface Item:", 0);
        l.setLayoutData((Object)new GridData());
        this.interfaceCombo = new Combo(triggerCompartment, 8);
        GridData gd = new GridData(768);
        this.interfaceCombo.setLayoutData((Object)gd);
        this.interfaceCombo.setVisibleItemCount(10);
        toolkit.adapt((Control)this.interfaceCombo, true, true);
        this.memberAwareConfiguration.configureMemberAwareness((Control)this.interfaceCombo);
        for (AbstractInterfaceItem item : this.interfaceItems) {
            if (item.getAllIncomingAbstractMessages().isEmpty()) continue;
            this.interfaceCombo.add(item.getDisplayName());
        }
    }

    private void createMessageCombo(Composite triggerCompartment, FormToolkit toolkit) {
        Label l = toolkit.createLabel(triggerCompartment, "Message:", 0);
        l.setLayoutData((Object)new GridData());
        this.messageCombo = new Combo(triggerCompartment, 8);
        this.messageCombo.setLayoutData((Object)new GridData(768));
        this.messageCombo.setVisibleItemCount(10);
        toolkit.adapt((Control)this.messageCombo, true, true);
        this.memberAwareConfiguration.configureMemberAwareness((Control)this.messageCombo);
    }

    private void addListeners() {
        this.triggerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionTriggerCompartment.this.updateMifAndGuard();
            }
        });
        this.mifViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionTriggerCompartment.this.updateCombos();
            }
        });
        this.interfaceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.updateInterfaceItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.messageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionTriggerCompartment.this.updateMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.guardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TransitionTriggerCompartment.this.refreshGuard();
            }
        });
    }

    private void updateMessage() {
        String msgName = this.messageCombo.getItem(this.messageCombo.getSelectionIndex());
        for (EObject message : this.currentMsgs) {
            if (!msgName.equals(this.nameProvider.getMessageName(message))) continue;
            MessageFromIf mif = (MessageFromIf)((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
            mif.setMessage(message);
            break;
        }
        this.triggerViewer.refresh();
        this.mifViewer.refresh();
    }

    private void updateInterfaceItem() {
        String ifName = this.interfaceCombo.getItem(this.interfaceCombo.getSelectionIndex());
        for (AbstractInterfaceItem item : this.interfaceItems) {
            if (!item.getDisplayName().equals(ifName)) continue;
            MessageFromIf mif = (MessageFromIf)((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
            mif.setFrom(item);
            this.updateCombos();
            break;
        }
        this.triggerViewer.refresh();
        this.mifViewer.refresh();
    }

    private void updateCombos() {
        Object sel;
        this.messageCombo.removeAll();
        if (this.mifViewer.getSelection() instanceof IStructuredSelection && (sel = ((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement()) instanceof MessageFromIf) {
            MessageFromIf mif = (MessageFromIf)sel;
            String[] items = this.interfaceCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(mif.getFrom().getDisplayName())) {
                    this.interfaceCombo.select(i);
                    this.currentMsgs = mif.getFrom().getAllIncomingAbstractMessages();
                    int pos = 0;
                    int idx = -1;
                    for (EObject message : this.currentMsgs) {
                        this.messageCombo.add(this.nameProvider.getMessageName(message));
                        if (message == mif.getMessage()) {
                            idx = pos;
                        }
                        ++pos;
                    }
                    if (idx == -1 && !this.currentMsgs.isEmpty()) {
                        idx = 0;
                        mif.setMessage(this.currentMsgs.get(idx));
                        this.triggerViewer.refresh();
                        this.mifViewer.refresh();
                    }
                    this.messageCombo.select(idx);
                    break;
                }
                ++i;
            }
        }
    }

    private void addNewTrigger() {
        Trigger tri = FSMFactory.eINSTANCE.createTrigger();
        EList triggers = ((TriggeredTransition)this.trans).getTriggers();
        triggers.add((Object)tri);
        if (!this.interfaceItems.isEmpty()) {
            MessageFromIf mif = this.createDefaultMif();
            tri.getMsgFromIfPairs().add((Object)mif);
        }
        this.triggerViewer.refresh();
        this.triggerViewer.setSelection((ISelection)new StructuredSelection(triggers.get(triggers.size() - 1)), true);
    }

    private MessageFromIf createDefaultMif() {
        MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
        for (AbstractInterfaceItem item : this.interfaceItems) {
            EList msgs = item.getAllIncomingAbstractMessages();
            if (msgs.isEmpty()) continue;
            mif.setFrom(item);
            mif.setMessage((EObject)msgs.get(0));
            return mif;
        }
        return null;
    }

    private void removeCurrentTrigger() {
        Object element = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        ((TriggeredTransition)this.trans).getTriggers().remove(element);
        this.triggerViewer.refresh();
        this.triggerViewer.setSelection((ISelection)new StructuredSelection(((TriggeredTransition)this.trans).getTriggers().get(0)), true);
    }

    private void addNewMif() {
        Trigger trigger = ((MessageFromInterfaceContentProvider)this.mifViewer.getContentProvider()).getCurrentTrigger();
        if (trigger != null) {
            MessageFromIf mif = this.createDefaultMif();
            trigger.getMsgFromIfPairs().add((Object)mif);
            this.mifViewer.refresh();
            this.triggerViewer.refresh();
            this.mifViewer.setSelection((ISelection)new StructuredSelection((Object)mif), true);
        }
    }

    private void removeCurrentMif() {
        Object element = ((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
        Trigger trigger = ((MessageFromInterfaceContentProvider)this.mifViewer.getContentProvider()).getCurrentTrigger();
        if (trigger != null) {
            trigger.getMsgFromIfPairs().remove(element);
            this.mifViewer.refresh();
            this.triggerViewer.refresh();
            this.mifViewer.setSelection((ISelection)new StructuredSelection(trigger.getMsgFromIfPairs().get(0)), true);
        }
    }

    private void updateMifAndGuard() {
        Object selected = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        this.mifViewer.setInput(selected);
        this.updateMifButton();
        if (selected instanceof Trigger) {
            this.mifViewer.setSelection((ISelection)new StructuredSelection(((Trigger)selected).getMsgFromIfPairs().get(0)), true);
            Guard guard2 = ((Trigger)selected).getGuard();
            String text = null;
            if (guard2 != null) {
                text = (String)this.m2s.convert(guard2.getGuard());
            }
            if (text == null) {
                text = "";
            }
            this.guardText.setText(text);
        }
    }

    private void disableAll(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(false);
            if (child instanceof Composite) {
                this.disableAll((Composite)child);
            }
            ++n2;
        }
    }

    private void refreshGuard() {
        Object element = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        if (element instanceof Trigger) {
            DetailCode dc = (DetailCode)this.s2m.convert(this.guardText.getText());
            Guard guard = null;
            if (dc != null) {
                guard = FSMFactory.eINSTANCE.createGuard();
                guard.setGuard(dc);
            }
            ((Trigger)element).setGuard(guard);
            this.parent.checkValidation();
        }
    }

    protected static class MessageFromInterfaceContentProvider
    implements IStructuredContentProvider {
        private Trigger currentTrigger = null;

        protected MessageFromInterfaceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.currentTrigger = newInput instanceof Trigger ? (Trigger)newInput : null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Trigger) {
                return ((Trigger)inputElement).getMsgFromIfPairs().toArray();
            }
            return new Object[0];
        }

        public Trigger getCurrentTrigger() {
            return this.currentTrigger;
        }
    }

    protected static class MessageFromInterfaceLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        protected MessageFromInterfaceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MessageFromIf) {
                MessageFromIf mif = (MessageFromIf)element;
                return FSMSupportUtil.getInstance().getFSMNameProvider().getMsgFromIfLabel(mif);
            }
            return super.getText(element);
        }
    }

    protected static class TriggerContentProvider
    implements IStructuredContentProvider {
        private Transition trans;

        protected TriggerContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Transition) {
                this.trans = (Transition)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.trans instanceof TriggeredTransition) {
                return ((TriggeredTransition)this.trans).getTriggers().toArray();
            }
            return new Object[0];
        }
    }

    protected static class TriggerLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        protected TriggerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Trigger) {
                Trigger trig = (Trigger)element;
                return FSMSupportUtil.getInstance().getFSMNameProvider().getTriggerLabel(trig);
            }
            return super.getText(element);
        }
    }
}

