/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.quickfix;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationAttribute;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.EnumAnnotationAttribute;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.SimpleAnnotationAttribute;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.ui.quickfix.FSMQuickfixProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.ui.quickfix.QuickfixExtensionManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.conversion.impl.QualifiedNameValueConverter;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.validation.Issue;

public class RoomQuickfixProvider
extends FSMQuickfixProvider {
    @Inject
    QualifiedNameValueConverter fqnConverter;

    public List<IssueResolution> getResolutions(Issue issue) {
        ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
        result.addAll(super.getResolutions(issue));
        IssueResolutionAcceptor acceptor = (IssueResolutionAcceptor)this.getIssueResolutionAcceptorProvider().get();
        QuickfixExtensionManager.getInstance().getResolutions(issue, acceptor);
        result.addAll(acceptor.getIssueResolutions());
        return result;
    }

    public boolean hasResolutionFor(String issueCode) {
        return super.hasResolutionFor(issueCode) || QuickfixExtensionManager.getInstance().hasResolutionFor(issueCode);
    }

    @Fix(value="RoomJavaValidator.WrongModelName")
    public void renameModel(Issue issue, IssueResolutionAcceptor acceptor) {
        String replacement = this.fqnConverter.toString(issue.getData()[1]);
        acceptor.accept(issue, "Rename model", "Replace model name with its location on the modelpath \nfollowed by its file name", "correction_change.gif", (IModification)new ReplaceModification(issue, replacement));
    }

    @Fix(value="RoomJavaValidator.ThreadMissing")
    public void fixMissingThread(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add a default thread", issue.getData()[0], "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                int offset = issue.getOffset() + issue.getLength() - 1;
                String insertion = "\n\t\t" + issue.getData()[0] + "\n\t";
                xtextDocument.replace(offset, 0, insertion);
            }
        });
    }

    @Fix(value="RoomJavaValidator.DuplicateActorInstanceMapping")
    public void removeDuplicateThreadMapping(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove duplicate mapping", "remove this mapping", "remove.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="RoomJavaValidator.WrongNamespace")
    public void fixWrongNamespace(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Replace with root namespace", issue.getData()[0], "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String replacement = issue.getData()[0];
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replacement);
            }
        });
    }

    @Fix(value="RoomJavaValidator.CircularContainment")
    public void fixCircularContainment(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Make attribute a reference", "add 'ref' keyword", "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                int offset = Integer.parseInt(issue.getData()[0]);
                xtextDocument.replace(issue.getOffset() + offset, 0, " ref");
            }
        });
    }

    @Fix(value="MultiplicityValidator.ActorRefChangeRefTypeToOptional")
    public void makeActorRefRefTypeOptional(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Make actor reference fixed", "optional ActorRef...", "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ActorRef ar = (ActorRef)element;
                ar.setRefType(ReferenceType.OPTIONAL);
            }
        });
    }

    @Fix(value="RoomJavaValidator.InvalidAnnotationTarget")
    public void fixInvalidAnnotationTarget(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove this annotation", "remove @" + issue.getData()[0] + "...", "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Annotation ann = (Annotation)element;
                Object getterResult = ann.eContainer().eGet(ann.eContainingFeature());
                ((List)getterResult).remove(ann);
            }
        });
        acceptor.accept(issue, "Add this target to the definition", issue.getData()[1], "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Annotation ann = (Annotation)element;
                ann.getType().getTargets().add((Object)issue.getData()[2]);
            }
        });
    }

    @Fix(value="BaseJavaValidator.DuplicateAnnotationTargets")
    public void fixDuplicateAnnotationTarget(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove the duplicate target", "remove " + issue.getData()[0], "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                AnnotationType at = (AnnotationType)element;
                Iterator it = at.getTargets().iterator();
                while (it.hasNext()) {
                    String tgt = (String)it.next();
                    if (!tgt.equals(issue.getData()[0])) continue;
                    it.remove();
                }
                at.getTargets().add((Object)issue.getData()[0]);
            }
        });
    }

    @Fix(value="BaseJavaValidator.MandatoryAttributeMissing")
    public void fixMissingAttribute(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing attribute", "add " + issue.getData()[0], "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Annotation ann = (Annotation)element;
                KeyValue kv = BaseFactory.eINSTANCE.createKeyValue();
                kv.setKey(issue.getData()[0]);
                for (AnnotationAttribute att : ann.getType().getAttributes()) {
                    if (!att.getName().equals(issue.getData()[0])) continue;
                    if (att instanceof SimpleAnnotationAttribute) {
                        switch (((SimpleAnnotationAttribute)att).getType()) {
                            case BOOL: {
                                BooleanLiteral bl = BaseFactory.eINSTANCE.createBooleanLiteral();
                                kv.setValue((Literal)bl);
                                break;
                            }
                            case CHAR: {
                                StringLiteral sl = BaseFactory.eINSTANCE.createStringLiteral();
                                sl.setValue("");
                                kv.setValue((Literal)sl);
                                break;
                            }
                            case INT: {
                                IntLiteral il = BaseFactory.eINSTANCE.createIntLiteral();
                                il.setValue(0L);
                                kv.setValue((Literal)il);
                                break;
                            }
                            case REAL: {
                                RealLiteral rl = BaseFactory.eINSTANCE.createRealLiteral();
                                rl.setValue(0.0);
                                kv.setValue((Literal)rl);
                            }
                        }
                    } else if (att instanceof EnumAnnotationAttribute) {
                        StringLiteral sl = BaseFactory.eINSTANCE.createStringLiteral();
                        sl.setValue((String)((EnumAnnotationAttribute)att).getValues().get(0));
                        kv.setValue((Literal)sl);
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unexpected sub type");
                    }
                    ann.getAttributes().add((Object)kv);
                    break;
                }
            }
        });
    }

    @Fix(value="BaseJavaValidator.UndfinedAnnotationAttribute")
    public void fixUndefinedAnnotationAttribute(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove undefined attribute", "remove " + issue.getData()[0], "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Annotation ann = (Annotation)element;
                Iterator it = ann.getAttributes().iterator();
                while (it.hasNext()) {
                    KeyValue kv = (KeyValue)it.next();
                    if (!kv.getKey().equals(issue.getData()[0])) continue;
                    it.remove();
                    break;
                }
            }
        });
    }

    @Fix(value="BaseJavaValidator.UndfinedAnnotationAttributeValue")
    public void fixUndefinedAnnotationAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        int i = 0;
        while (i < issue.getData().length) {
            acceptor.accept(issue, "Change attribute value to " + issue.getData()[i], "... = " + issue.getData()[i], "add.gif", (ISemanticModification)new ChangeAnnotationAttributeModification(issue.getData()[i]));
            ++i;
        }
    }

    @Fix(value="BaseJavaValidator.DuplicateAnnotationAttribute")
    public void fixDuplicateAnnotationAttribute(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove duplicate attribute " + issue.getData()[0], "remove " + issue.getData()[0], "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Annotation ann = (Annotation)element;
                int i = ann.getAttributes().size() - 1;
                while (i >= 0) {
                    KeyValue kv = (KeyValue)ann.getAttributes().get(i);
                    if (kv.getKey().equals(issue.getData()[0])) {
                        ann.getAttributes().remove(i);
                        break;
                    }
                    --i;
                }
            }
        });
    }

    @Fix(value="RoomJavaValidator.OperationMissingOverride")
    public void fixOperationMissingOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Mark operation as override", "add 'override' keyword", "add.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ((StandardOperation)element).setOverride(true);
            }
        });
    }

    @Fix(value="RoomJavaValidator.OperationExtraneousOverride")
    public void fixOperationExtraneousOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove 'override' keyword", "", "remove.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ((StandardOperation)element).setOverride(false);
            }
        });
    }

    @Fix(value="RoomJavaValidator.InconsistentCommType")
    public void makeActorClassCommTypeLikeBaseClass(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Set communication type as for base class.", String.valueOf(issue.getData()[0]) + " ActorClass " + issue.getData()[1] + " ...", "correction_change.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ActorClass ac = (ActorClass)element;
                ac.setCommType(ComponentCommunicationType.get((String)issue.getData()[0]));
            }
        });
    }

    @Fix(value="RoomJavaValidator.DeprecatedMessageDataName")
    public void removeDeprecatedMessageDataName(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Omit message data name.", "Remove the deprecated name for the message data.", "correction_change.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                MessageData d = (MessageData)element;
                d.setDeprecatedName(null);
            }
        });
    }

    private final class ChangeAnnotationAttributeModification
    implements ISemanticModification {
        private String val;

        private ChangeAnnotationAttributeModification(String val) {
            this.val = val;
        }

        public void apply(EObject element, IModificationContext context) throws Exception {
            KeyValue kv = (KeyValue)element;
            StringLiteral sl = BaseFactory.eINSTANCE.createStringLiteral();
            sl.setValue(this.val);
            kv.setValue((Literal)sl);
        }
    }
}

