/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.Color;
import java.awt.Font;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.colors.FontColorDetector;
import org.knowm.xchart.style.theme.Theme;

public class CategoryStyler
extends AxesChartStyler {
    private CategorySeries.CategorySeriesRenderStyle chartCategorySeriesRenderStyle;
    private double availableSpaceFill;
    private boolean isOverlapped;
    private boolean isStacked;
    private boolean isLabelsVisible = false;
    private boolean showStackSum = false;
    private Font labelsFont;
    private Color labelsFontColor;
    private int labelsRotation;
    private double labelsPosition;
    private boolean isLabelsFontColorAutomaticEnabled;
    private Color labelsFontColorAutomaticLight;
    private Color labelsFontColorAutomaticDark;

    public CategoryStyler() {
        this.setAllStyles();
    }

    @Override
    protected void setAllStyles() {
        super.setAllStyles();
        this.chartCategorySeriesRenderStyle = CategorySeries.CategorySeriesRenderStyle.Bar;
        this.availableSpaceFill = this.theme.getAvailableSpaceFill();
        this.isOverlapped = this.theme.isOverlapped();
        this.isStacked = false;
        this.isLabelsVisible = false;
        this.labelsFont = this.theme.getBaseFont();
        this.labelsFontColor = this.theme.getChartFontColor();
        this.labelsRotation = 0;
        this.labelsPosition = 0.5;
        this.isLabelsFontColorAutomaticEnabled = this.theme.isLabelsFontColorAutomaticEnabled();
        this.labelsFontColorAutomaticLight = this.theme.getLabelsFontColorAutomaticLight();
        this.labelsFontColorAutomaticDark = this.theme.getLabelsFontColorAutomaticDark();
    }

    public CategorySeries.CategorySeriesRenderStyle getDefaultSeriesRenderStyle() {
        return this.chartCategorySeriesRenderStyle;
    }

    public CategoryStyler setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle chartCategorySeriesRenderStyle) {
        this.chartCategorySeriesRenderStyle = chartCategorySeriesRenderStyle;
        return this;
    }

    public double getAvailableSpaceFill() {
        return this.availableSpaceFill;
    }

    public CategoryStyler setAvailableSpaceFill(double availableSpaceFill) {
        this.availableSpaceFill = availableSpaceFill;
        return this;
    }

    public boolean isOverlapped() {
        return this.isOverlapped;
    }

    public CategoryStyler setOverlapped(boolean isOverlapped) {
        this.isOverlapped = isOverlapped;
        return this;
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public CategoryStyler setStacked(boolean isStacked) {
        this.isStacked = isStacked;
        return this;
    }

    public boolean isLabelsVisible() {
        return this.isLabelsVisible;
    }

    public CategoryStyler setLabelsVisible(boolean labelsVisible) {
        this.isLabelsVisible = labelsVisible;
        return this;
    }

    public boolean isShowStackSum() {
        return this.showStackSum;
    }

    public CategoryStyler setShowStackSum(boolean showStackSum) {
        this.showStackSum = showStackSum;
        return this;
    }

    public Font getLabelsFont() {
        return this.labelsFont;
    }

    public CategoryStyler setLabelsFont(Font labelsFont) {
        this.labelsFont = labelsFont;
        return this;
    }

    public Color getLabelsFontColor() {
        return this.labelsFontColor;
    }

    public Color getLabelsFontColor(Color backgroundColor) {
        return FontColorDetector.getAutomaticFontColor(backgroundColor, this.labelsFontColorAutomaticDark, this.labelsFontColorAutomaticLight);
    }

    public CategoryStyler setLabelsFontColor(Color labelsFontColor) {
        this.labelsFontColor = labelsFontColor;
        return this;
    }

    public int getLabelsRotation() {
        return this.labelsRotation;
    }

    public CategoryStyler setLabelsRotation(int labelsRotation) {
        this.labelsRotation = labelsRotation;
        return this;
    }

    public double getLabelsPosition() {
        return this.labelsPosition;
    }

    public CategoryStyler setLabelsPosition(double labelsPosition) {
        if (labelsPosition < 0.0 || labelsPosition > 1.0) {
            throw new IllegalArgumentException("Annotations position must between 0 and 1!!!");
        }
        this.labelsPosition = labelsPosition;
        return this;
    }

    public boolean isLabelsFontColorAutomaticEnabled() {
        return this.isLabelsFontColorAutomaticEnabled;
    }

    public CategoryStyler setLabelsFontColorAutomaticEnabled(boolean isLabelsFontColorAutomaticEnabled) {
        this.isLabelsFontColorAutomaticEnabled = isLabelsFontColorAutomaticEnabled;
        return this;
    }

    public Color getLabelsFontColorAutomaticLight() {
        return this.labelsFontColorAutomaticLight;
    }

    public CategoryStyler setLabelsFontColorAutomaticLight(Color labelsFontColorAutomaticLight) {
        this.labelsFontColorAutomaticLight = labelsFontColorAutomaticLight;
        return this;
    }

    public Color getLabelsFontColorAutomaticDark() {
        return this.labelsFontColorAutomaticDark;
    }

    public CategoryStyler setLabelsFontColorAutomaticDark(Color labelsFontColorAutomaticDark) {
        this.labelsFontColorAutomaticDark = labelsFontColorAutomaticDark;
        return this;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.setAllStyles();
    }
}

